/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.BucketAggregationSelectorScript;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.Script;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class BucketSelectorPipelineAggregator
extends PipelineAggregator {
    private BucketHelpers.GapPolicy gapPolicy;
    private Script script;
    private Map<String, String> bucketsPathsMap;

    BucketSelectorPipelineAggregator(String name, Map<String, String> bucketsPathsMap, Script script, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, bucketsPathsMap.values().toArray(new String[0]), metadata);
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
        this.gapPolicy = gapPolicy;
    }

    public BucketSelectorPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.bucketsPathsMap = (Map)in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        this.gapPolicy.writeTo(out);
        out.writeGenericValue(this.bucketsPathsMap);
    }

    @Override
    public String getWriteableName() {
        return "bucket_selector";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List<InternalMultiBucketAggregation.InternalBucket> buckets = originalAgg.getBuckets();
        BucketAggregationSelectorScript.Factory factory = reduceContext.scriptService().compile(this.script, BucketAggregationSelectorScript.CONTEXT);
        ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            if (this.script.getParams() != null) {
                vars.putAll(this.script.getParams());
            }
            for (Map.Entry<String, String> entry : this.bucketsPathsMap.entrySet()) {
                String varName = entry.getKey();
                String bucketsPath = entry.getValue();
                Double value = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)originalAgg, bucket, bucketsPath, this.gapPolicy);
                vars.put(varName, value);
            }
            BucketAggregationSelectorScript executableScript = factory.newInstance(vars);
            if (!executableScript.execute()) continue;
            newBuckets.add(bucket);
        }
        return originalAgg.create(newBuckets);
    }
}

