/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.index.FreqTermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant.SignificantTextAggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant.SignificantTextAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class SignificantTextAggregatorFactory
extends AggregatorFactory
implements Releasable {
    private final IncludeExclude includeExclude;
    private String indexedFieldName;
    private MappedFieldType fieldType;
    private final String[] sourceFieldNames;
    private FilterableTermsEnum termsEnum;
    private int numberOfAggregatorsCreated;
    private final Query filter;
    private final int supersetNumDocs;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;
    private final DocValueFormat format = DocValueFormat.RAW;
    private final boolean filterDuplicateText;

    public SignificantTextAggregatorFactory(String name, IncludeExclude includeExclude, QueryBuilder filterBuilder, TermsAggregator.BucketCountThresholds bucketCountThresholds, SignificanceHeuristic significanceHeuristic, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, String fieldName, String[] sourceFieldNames, boolean filterDuplicateText, Map<String, Object> metaData) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metaData);
        String[] stringArray;
        this.fieldType = queryShardContext.fieldMapper(fieldName);
        String string = this.indexedFieldName = this.fieldType != null ? this.fieldType.name() : fieldName;
        if (sourceFieldNames == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.indexedFieldName;
        } else {
            stringArray = sourceFieldNames;
        }
        this.sourceFieldNames = stringArray;
        this.includeExclude = includeExclude;
        this.filter = filterBuilder == null ? null : filterBuilder.toQuery(queryShardContext);
        this.filterDuplicateText = filterDuplicateText;
        IndexSearcher searcher = queryShardContext.searcher();
        this.supersetNumDocs = this.filter == null ? searcher.getIndexReader().maxDoc() : searcher.count(this.filter);
        this.bucketCountThresholds = bucketCountThresholds;
        this.significanceHeuristic = significanceHeuristic;
    }

    public long getSupersetNumDocs() {
        return this.supersetNumDocs;
    }

    private FilterableTermsEnum getTermsEnum(String field) throws IOException {
        if (this.termsEnum != null) {
            return this.termsEnum;
        }
        IndexReader reader = this.queryShardContext.getIndexReader();
        this.termsEnum = this.numberOfAggregatorsCreated > 1 ? new FreqTermsEnum(reader, field, true, false, this.filter, this.queryShardContext.bigArrays()) : new FilterableTermsEnum(reader, this.indexedFieldName, 0, this.filter);
        return this.termsEnum;
    }

    private long getBackgroundFrequency(String value) throws IOException {
        Query query = this.fieldType.termQuery(value, this.queryShardContext);
        if (query instanceof TermQuery) {
            Term term = ((TermQuery)query).getTerm();
            FilterableTermsEnum termsEnum = this.getTermsEnum(term.field());
            if (termsEnum.seekExact(term.bytes())) {
                return termsEnum.docFreq();
            }
            return 0L;
        }
        if (this.filter != null) {
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.FILTER).add(this.filter, BooleanClause.Occur.FILTER).build();
        }
        return this.queryShardContext.searcher().count(query);
    }

    public long getBackgroundFrequency(BytesRef termBytes) throws IOException {
        String value = this.format.format(termBytes).toString();
        return this.getBackgroundFrequency(value);
    }

    @Override
    public void close() {
        try {
            if (this.termsEnum instanceof Releasable) {
                ((Releasable)((Object)this.termsEnum)).close();
            }
        }
        finally {
            this.termsEnum = null;
        }
    }

    @Override
    protected Aggregator createInternal(SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return SignificantTextAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        ++this.numberOfAggregatorsCreated;
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (bucketCountThresholds.getShardSize() == SignificantTextAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(2 * BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        IncludeExclude.StringFilter incExcFilter = this.includeExclude == null ? null : this.includeExclude.convertToStringFilter(DocValueFormat.RAW);
        return new SignificantTextAggregator(this.name, this.factories, searchContext, parent, pipelineAggregators, bucketCountThresholds, incExcFilter, this.significanceHeuristic, this, this.indexedFieldName, this.sourceFieldNames, this.filterDuplicateText, metaData);
    }
}

