/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.GeoGrid;

public abstract class InternalGeoGridBucket<B extends InternalGeoGridBucket>
extends InternalMultiBucketAggregation.InternalBucket
implements GeoGrid.Bucket,
Comparable<InternalGeoGridBucket> {
    protected long hashAsLong;
    protected long docCount;
    protected InternalAggregations aggregations;
    long bucketOrd;

    public InternalGeoGridBucket(long hashAsLong, long docCount, InternalAggregations aggregations) {
        this.docCount = docCount;
        this.aggregations = aggregations;
        this.hashAsLong = hashAsLong;
    }

    public InternalGeoGridBucket(StreamInput in) throws IOException {
        this.hashAsLong = in.readLong();
        this.docCount = in.readVLong();
        this.aggregations = new InternalAggregations(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.hashAsLong);
        out.writeVLong(this.docCount);
        this.aggregations.writeTo(out);
    }

    long hashAsLong() {
        return this.hashAsLong;
    }

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public int compareTo(InternalGeoGridBucket other) {
        if (this.hashAsLong > other.hashAsLong) {
            return 1;
        }
        if (this.hashAsLong < other.hashAsLong) {
            return -1;
        }
        return 0;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalGeoGridBucket bucket = (InternalGeoGridBucket)o;
        return this.hashAsLong == bucket.hashAsLong && this.docCount == bucket.docCount && Objects.equals(this.aggregations, bucket.aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.hashAsLong, this.docCount, this.aggregations);
    }
}

