/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public abstract class DeferableBucketAggregator
extends BucketsAggregator {
    private DeferringBucketCollector recordingWrapper;

    protected DeferableBucketAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
    }

    @Override
    protected void doPreCollection() throws IOException {
        ArrayList<BucketCollector> collectors = new ArrayList<BucketCollector>();
        ArrayList<BucketCollector> deferredCollectors = new ArrayList<BucketCollector>();
        for (int i = 0; i < this.subAggregators.length; ++i) {
            if (this.shouldDefer(this.subAggregators[i])) {
                if (this.recordingWrapper == null) {
                    this.recordingWrapper = this.getDeferringCollector();
                }
                deferredCollectors.add(this.subAggregators[i]);
                this.subAggregators[i] = this.recordingWrapper.wrap(this.subAggregators[i]);
                continue;
            }
            collectors.add(this.subAggregators[i]);
        }
        if (this.recordingWrapper != null) {
            this.recordingWrapper.setDeferredCollector(deferredCollectors);
            collectors.add(this.recordingWrapper);
        }
        this.collectableSubAggregators = MultiBucketCollector.wrap(collectors);
    }

    public static boolean descendsFromGlobalAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == GlobalAggregator.class) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    public DeferringBucketCollector getDeferringCollector() {
        return new BestBucketsDeferringCollector(this.context(), DeferableBucketAggregator.descendsFromGlobalAggregator(this.parent()));
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return false;
    }

    protected final void runDeferredCollections(long ... bucketOrds) throws IOException {
        if (this.recordingWrapper != null) {
            this.recordingWrapper.replay(bucketOrds);
        }
    }
}

