/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public abstract class Aggregator
extends BucketCollector
implements Releasable {
    public static boolean descendsFromBucketAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof BucketsAggregator) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    public abstract String name();

    public abstract SearchContext context();

    public abstract Aggregator parent();

    public abstract Aggregator subAggregator(String var1);

    public abstract InternalAggregation buildAggregation(long var1) throws IOException;

    public abstract InternalAggregation buildEmptyAggregation();

    public static enum SubAggCollectionMode implements Writeable
    {
        DEPTH_FIRST(new ParseField("depth_first", new String[0])),
        BREADTH_FIRST(new ParseField("breadth_first", new String[0]));

        public static final ParseField KEY;
        private final ParseField parseField;

        private SubAggCollectionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static SubAggCollectionMode parse(String value, DeprecationHandler deprecationHandler) {
            SubAggCollectionMode[] modes;
            for (SubAggCollectionMode mode : modes = SubAggCollectionMode.values()) {
                if (!mode.parseField.match(value, deprecationHandler)) continue;
                return mode;
            }
            throw new ElasticsearchParseException("no [{}] found for value [{}]", KEY.getPreferredName(), value);
        }

        public static SubAggCollectionMode readFromStream(StreamInput in) throws IOException {
            return in.readEnum(SubAggCollectionMode.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        static {
            KEY = new ParseField("collect_mode", new String[0]);
        }
    }

    @FunctionalInterface
    public static interface Parser {
        public AggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

