/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.logging.log4j.LogManager;

public final class DeprecationMap
implements Map<String, Object> {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(DeprecationMap.class));
    private final Map<String, Object> delegate;
    private final Map<String, String> deprecations;
    private final String logKeyPrefix;

    public DeprecationMap(Map<String, Object> delegate, Map<String, String> deprecations, String logKeyPrefix) {
        this.delegate = delegate;
        this.deprecations = deprecations;
        this.logKeyPrefix = logKeyPrefix;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        String deprecationMessage = this.deprecations.get(key);
        if (deprecationMessage != null) {
            deprecationLogger.deprecatedAndMaybeLog(this.logKeyPrefix + "_" + key, deprecationMessage, new Object[0]);
        }
        return this.delegate.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }
}

