/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestClearIndicesCacheAction
extends BaseRestHandler {
    public RestClearIndicesCacheAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.POST, "/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_cache/clear", this);
    }

    @Override
    public String getName() {
        return "clear_indices_cache_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClearIndicesCacheRequest clearIndicesCacheRequest = new ClearIndicesCacheRequest(Strings.splitStringByCommaToArray(request.param("index")));
        clearIndicesCacheRequest.indicesOptions(IndicesOptions.fromRequest(request, clearIndicesCacheRequest.indicesOptions()));
        RestClearIndicesCacheAction.fromRequest(request, clearIndicesCacheRequest);
        return channel -> client.admin().indices().clearCache(clearIndicesCacheRequest, new RestToXContentListener<ClearIndicesCacheResponse>((RestChannel)channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    public static ClearIndicesCacheRequest fromRequest(RestRequest request, ClearIndicesCacheRequest clearIndicesCacheRequest) {
        clearIndicesCacheRequest.queryCache(request.paramAsBoolean("query", clearIndicesCacheRequest.queryCache()));
        clearIndicesCacheRequest.requestCache(request.paramAsBoolean("request", clearIndicesCacheRequest.requestCache()));
        clearIndicesCacheRequest.fieldDataCache(request.paramAsBoolean("fielddata", clearIndicesCacheRequest.fieldDataCache()));
        clearIndicesCacheRequest.fields(request.paramAsStringArray("fields", clearIndicesCacheRequest.fields()));
        return clearIndicesCacheRequest;
    }
}

