/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.persistent.decider;

import java.util.Locale;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.persistent.decider.AssignmentDecision;

public class EnableAssignmentDecider {
    public static final Setting<Allocation> CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING = new Setting<Allocation>("cluster.persistent_tasks.allocation.enable", Allocation.ALL.toString(), Allocation::fromString, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile Allocation enableAssignment;

    public EnableAssignmentDecider(Settings settings, ClusterSettings clusterSettings) {
        this.enableAssignment = CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING, this::setEnableAssignment);
    }

    public void setEnableAssignment(Allocation enableAssignment) {
        this.enableAssignment = enableAssignment;
    }

    public AssignmentDecision canAssign() {
        if (this.enableAssignment == Allocation.NONE) {
            return new AssignmentDecision(AssignmentDecision.Type.NO, "no persistent task assignments are allowed due to cluster settings");
        }
        return AssignmentDecision.YES;
    }

    public static enum Allocation {
        NONE,
        ALL;


        public static Allocation fromString(String strValue) {
            if (strValue == null) {
                return null;
            }
            String value = strValue.toUpperCase(Locale.ROOT);
            try {
                return Allocation.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal value [" + value + "] for [" + CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING.getKey() + "]");
            }
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

