/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RankFeatureFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RankFeatureMetaFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RankFeaturesFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ScaledFloatFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SearchAsYouTypeFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TokenCountFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.RankFeatureQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.plugins.MapperPlugin;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.plugins.Plugin;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.plugins.SearchPlugin;

public class MapperExtrasPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, Mapper.TypeParser> mappers = new LinkedHashMap<String, Mapper.TypeParser>();
        mappers.put("scaled_float", new ScaledFloatFieldMapper.TypeParser());
        mappers.put("token_count", new TokenCountFieldMapper.TypeParser());
        mappers.put("rank_feature", new RankFeatureFieldMapper.TypeParser());
        mappers.put("rank_features", new RankFeaturesFieldMapper.TypeParser());
        mappers.put("search_as_you_type", new SearchAsYouTypeFieldMapper.TypeParser());
        return Collections.unmodifiableMap(mappers);
    }

    @Override
    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_feature", new RankFeatureMetaFieldMapper.TypeParser());
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec<RankFeatureQueryBuilder>("rank_feature", RankFeatureQueryBuilder::new, p -> RankFeatureQueryBuilder.PARSER.parse(p, null)));
    }
}

