/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Iterators;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldAliasMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    final CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType;
    private final CopyOnWriteHashMap<String, String> aliasToConcreteName;
    private final CopyOnWriteHashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers;
    private final int maxDynamicKeyDepth;

    FieldTypeLookup() {
        this.fullNameToFieldType = new CopyOnWriteHashMap();
        this.aliasToConcreteName = new CopyOnWriteHashMap();
        this.dynamicKeyMappers = new CopyOnWriteHashMap();
        this.maxDynamicKeyDepth = 0;
    }

    private FieldTypeLookup(CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType, CopyOnWriteHashMap<String, String> aliasToConcreteName, CopyOnWriteHashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers, int maxDynamicKeyDepth) {
        this.fullNameToFieldType = fullNameToFieldType;
        this.aliasToConcreteName = aliasToConcreteName;
        this.dynamicKeyMappers = dynamicKeyMappers;
        this.maxDynamicKeyDepth = maxDynamicKeyDepth;
    }

    public FieldTypeLookup copyAndAddAll(String type, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        Objects.requireNonNull(type, "type must not be null");
        if ("_default_".equals(type)) {
            throw new IllegalArgumentException("Default mappings should not be added to the lookup");
        }
        CopyOnWriteHashMap<String, MappedFieldType> fullName = this.fullNameToFieldType;
        CopyOnWriteHashMap<String, String> aliases = this.aliasToConcreteName;
        CopyOnWriteHashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers = this.dynamicKeyMappers;
        for (FieldMapper fieldMapper : fieldMappers) {
            MappedFieldType fullNameFieldType;
            String fieldName = fieldMapper.name();
            MappedFieldType fieldType = fieldMapper.fieldType();
            if (!Objects.equals(fieldType, fullNameFieldType = fullName.get(fieldType.name()))) {
                fullName = fullName.copyAndPut(fieldType.name(), fieldType);
            }
            if (!(fieldMapper instanceof DynamicKeyFieldMapper)) continue;
            DynamicKeyFieldMapper dynamicKeyMapper = (DynamicKeyFieldMapper)fieldMapper;
            dynamicKeyMappers = dynamicKeyMappers.copyAndPut(fieldName, dynamicKeyMapper);
        }
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            aliases = aliases.copyAndPut(aliasName, path);
        }
        int maxDynamicKeyDepth = FieldTypeLookup.getMaxDynamicKeyDepth(aliases, dynamicKeyMappers);
        return new FieldTypeLookup(fullName, aliases, dynamicKeyMappers, maxDynamicKeyDepth);
    }

    private static int getMaxDynamicKeyDepth(CopyOnWriteHashMap<String, String> aliases, CopyOnWriteHashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers) {
        int maxFieldDepth = 0;
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            String aliasName = entry.getKey();
            String path = entry.getValue();
            if (!dynamicKeyMappers.containsKey(path)) continue;
            maxFieldDepth = Math.max(maxFieldDepth, FieldTypeLookup.fieldDepth(aliasName));
        }
        for (String fieldName : dynamicKeyMappers.keySet()) {
            if (!dynamicKeyMappers.containsKey(fieldName)) continue;
            maxFieldDepth = Math.max(maxFieldDepth, FieldTypeLookup.fieldDepth(fieldName));
        }
        return maxFieldDepth;
    }

    private static int fieldDepth(String field) {
        int numDots = 0;
        int dotIndex = -1;
        while ((dotIndex = field.indexOf(46, dotIndex + 1)) >= 0) {
            ++numDots;
        }
        return numDots + 1;
    }

    public MappedFieldType get(String field) {
        String concreteField = this.aliasToConcreteName.getOrDefault(field, field);
        MappedFieldType fieldType = this.fullNameToFieldType.get(concreteField);
        if (fieldType != null) {
            return fieldType;
        }
        return !this.dynamicKeyMappers.isEmpty() ? this.getKeyedFieldType(field) : null;
    }

    private MappedFieldType getKeyedFieldType(String field) {
        String parentField;
        String concreteField;
        DynamicKeyFieldMapper mapper;
        int dotIndex = -1;
        int fieldDepth = 0;
        do {
            if (++fieldDepth > this.maxDynamicKeyDepth) {
                return null;
            }
            if ((dotIndex = field.indexOf(46, dotIndex + 1)) >= 0) continue;
            return null;
        } while ((mapper = this.dynamicKeyMappers.get(concreteField = this.aliasToConcreteName.getOrDefault(parentField = field.substring(0, dotIndex), parentField))) == null);
        String key = field.substring(dotIndex + 1);
        return mapper.keyedFieldType(key);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = new HashSet<String>();
        for (MappedFieldType fieldType : this) {
            if (!Regex.simpleMatch(pattern, fieldType.name())) continue;
            fields.add(fieldType.name());
        }
        for (String aliasName : this.aliasToConcreteName.keySet()) {
            if (!Regex.simpleMatch(pattern, aliasName)) continue;
            fields.add(aliasName);
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        Iterator<MappedFieldType> concreteFieldTypes = this.fullNameToFieldType.values().iterator();
        if (this.dynamicKeyMappers.isEmpty()) {
            return concreteFieldTypes;
        }
        Iterator keyedFieldTypes = this.dynamicKeyMappers.values().stream().map(mapper -> mapper.keyedFieldType("")).iterator();
        return Iterators.concat(concreteFieldTypes, keyedFieldTypes);
    }

    int maxKeyedLookupDepth() {
        return this.maxDynamicKeyDepth;
    }
}

