/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.AbstractIndexComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldDataCache;

public abstract class AbstractIndexFieldData<FD extends AtomicFieldData>
extends AbstractIndexComponent
implements IndexFieldData<FD> {
    private final String fieldName;
    protected final IndexFieldDataCache cache;

    public AbstractIndexFieldData(IndexSettings indexSettings, String fieldName, IndexFieldDataCache cache) {
        super(indexSettings);
        this.fieldName = fieldName;
        this.cache = cache;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void clear() {
        this.cache.clear(this.fieldName);
    }

    @Override
    public FD load(LeafReaderContext context) {
        if (context.reader().getFieldInfos().fieldInfo(this.fieldName) == null) {
            return this.empty(context.reader().maxDoc());
        }
        try {
            Object fd = this.cache.load(context, this);
            return fd;
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e);
        }
    }

    protected abstract FD empty(int var1);

    public static interface PerValueEstimator {
        public long bytesPerValue(BytesRef var1);

        public TermsEnum beforeLoad(Terms var1) throws IOException;

        public void afterLoad(TermsEnum var1, long var2);
    }
}

