/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpPipelinedMessage;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpPipelinedRequest;

public class HttpPipeliningAggregator<Response extends HttpPipelinedMessage, Listener> {
    private final int maxEventsHeld;
    private final PriorityQueue<Tuple<Response, Listener>> outboundHoldingQueue;
    private int readSequence;
    private int writeSequence;

    public HttpPipeliningAggregator(int maxEventsHeld) {
        this.maxEventsHeld = maxEventsHeld;
        this.outboundHoldingQueue = new PriorityQueue<Tuple>(1, Comparator.comparing(Tuple::v1));
    }

    public <Request> HttpPipelinedRequest<Request> read(Request request) {
        return new HttpPipelinedRequest<Request>(this.readSequence++, request);
    }

    public List<Tuple<Response, Listener>> write(Response response, Listener listener) {
        if (this.outboundHoldingQueue.size() < this.maxEventsHeld) {
            Tuple<Response, Listener> top;
            ArrayList<Tuple<Response, Listener>> readyResponses = new ArrayList<Tuple<Response, Listener>>();
            this.outboundHoldingQueue.add(new Tuple<Response, Listener>(response, listener));
            while (!this.outboundHoldingQueue.isEmpty() && ((HttpPipelinedMessage)(top = this.outboundHoldingQueue.peek()).v1()).getSequence() == this.writeSequence) {
                this.outboundHoldingQueue.poll();
                readyResponses.add(top);
                ++this.writeSequence;
            }
            return readyResponses;
        }
        int eventCount = this.outboundHoldingQueue.size() + 1;
        throw new IllegalStateException("Too many pipelined events [" + eventCount + "]. Max events allowed [" + this.maxEventsHeld + "].");
    }

    public List<Tuple<Response, Listener>> removeAllInflightResponses() {
        ArrayList<Tuple<Response, Listener>> responses = new ArrayList<Tuple<Response, Listener>>(this.outboundHoldingQueue);
        this.outboundHoldingQueue.clear();
        return responses;
    }
}

