/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SettingsException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpTransportSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestUtils;

public class CorsHandler {
    public static final String ANY_ORIGIN = "*";
    public static final String ORIGIN = "origin";
    public static final String DATE = "date";
    public static final String VARY = "vary";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "access-control-request-method";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "access-control-allow-origin";

    private CorsHandler() {
    }

    public static Config disabled() {
        Config.Builder builder = new Config.Builder();
        builder.enabled = false;
        return new Config(builder);
    }

    public static Config fromSettings(Settings settings) {
        Config.Builder builder;
        if (!HttpTransportSettings.SETTING_CORS_ENABLED.get(settings).booleanValue()) {
            return CorsHandler.disabled();
        }
        String origin = HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.get(settings);
        if (Strings.isNullOrEmpty(origin)) {
            builder = Config.Builder.forOrigins(new String[0]);
        } else if (origin.equals(ANY_ORIGIN)) {
            builder = Config.Builder.forAnyOrigin();
        } else {
            try {
                Pattern p = RestUtils.checkCorsSettingForRegex(origin);
                builder = p == null ? Config.Builder.forOrigins(RestUtils.corsSettingAsArray(origin)) : Config.Builder.forPattern(p);
            }
            catch (PatternSyntaxException e) {
                throw new SettingsException("Bad regex in [" + HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.getKey() + "]: [" + origin + "]", e);
            }
        }
        if (HttpTransportSettings.SETTING_CORS_ALLOW_CREDENTIALS.get(settings).booleanValue()) {
            builder.allowCredentials();
        }
        String[] strMethods = Strings.tokenizeToStringArray(HttpTransportSettings.SETTING_CORS_ALLOW_METHODS.get(settings), ",");
        RestRequest.Method[] methods = (RestRequest.Method[])Arrays.stream(strMethods).map(s -> s.toUpperCase(Locale.ENGLISH)).map(RestRequest.Method::valueOf).toArray(RestRequest.Method[]::new);
        Config config = builder.allowedRequestMethods(methods).maxAge(HttpTransportSettings.SETTING_CORS_MAX_AGE.get(settings)).allowedRequestHeaders(Strings.tokenizeToStringArray(HttpTransportSettings.SETTING_CORS_ALLOW_HEADERS.get(settings), ",")).build();
        return config;
    }

    public static class Config {
        private final boolean enabled;
        private final Optional<Set<String>> origins;
        private final Optional<Pattern> pattern;
        private final boolean anyOrigin;
        private final boolean credentialsAllowed;
        private final Set<RestRequest.Method> allowedRequestMethods;
        private final Set<String> allowedRequestHeaders;
        private final long maxAge;

        public Config(Builder builder) {
            this.enabled = builder.enabled;
            this.origins = builder.origins.map(HashSet::new);
            this.pattern = builder.pattern;
            this.anyOrigin = builder.anyOrigin;
            this.credentialsAllowed = builder.allowCredentials;
            this.allowedRequestMethods = Collections.unmodifiableSet(builder.requestMethods);
            this.allowedRequestHeaders = Collections.unmodifiableSet(builder.requestHeaders);
            this.maxAge = builder.maxAge;
        }

        public boolean isCorsSupportEnabled() {
            return this.enabled;
        }

        public boolean isAnyOriginSupported() {
            return this.anyOrigin;
        }

        public boolean isOriginAllowed(String origin) {
            if (this.origins.isPresent()) {
                return this.origins.get().contains(origin);
            }
            if (this.pattern.isPresent()) {
                return this.pattern.get().matcher(origin).matches();
            }
            return false;
        }

        public boolean isCredentialsAllowed() {
            return this.credentialsAllowed;
        }

        public Set<RestRequest.Method> allowedRequestMethods() {
            return this.allowedRequestMethods;
        }

        public Set<String> allowedRequestHeaders() {
            return this.allowedRequestHeaders;
        }

        public long maxAge() {
            return this.maxAge;
        }

        public Optional<Set<String>> origins() {
            return this.origins;
        }

        public String toString() {
            return "Config{enabled=" + this.enabled + ", origins=" + this.origins + ", pattern=" + this.pattern + ", anyOrigin=" + this.anyOrigin + ", credentialsAllowed=" + this.credentialsAllowed + ", allowedRequestMethods=" + this.allowedRequestMethods + ", allowedRequestHeaders=" + this.allowedRequestHeaders + ", maxAge=" + this.maxAge + '}';
        }

        private static class Builder {
            private boolean enabled = true;
            private Optional<Set<String>> origins;
            private Optional<Pattern> pattern;
            private final boolean anyOrigin;
            private boolean allowCredentials = false;
            long maxAge;
            private final Set<RestRequest.Method> requestMethods = new HashSet<RestRequest.Method>();
            private final Set<String> requestHeaders = new HashSet<String>();

            private Builder() {
                this.anyOrigin = true;
                this.origins = Optional.empty();
                this.pattern = Optional.empty();
            }

            private Builder(String ... origins) {
                this.origins = Optional.of(new LinkedHashSet<String>(Arrays.asList(origins)));
                this.pattern = Optional.empty();
                this.anyOrigin = false;
            }

            private Builder(Pattern pattern) {
                this.pattern = Optional.of(pattern);
                this.origins = Optional.empty();
                this.anyOrigin = false;
            }

            static Builder forOrigins(String ... origins) {
                return new Builder(origins);
            }

            static Builder forAnyOrigin() {
                return new Builder();
            }

            static Builder forPattern(Pattern pattern) {
                return new Builder(pattern);
            }

            Builder allowCredentials() {
                this.allowCredentials = true;
                return this;
            }

            public Builder allowedRequestMethods(RestRequest.Method[] methods) {
                this.requestMethods.addAll(Arrays.asList(methods));
                return this;
            }

            public Builder maxAge(int maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            public Builder allowedRequestHeaders(String[] headers) {
                this.requestHeaders.addAll(Arrays.asList(headers));
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }
}

