/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.filtering;

import java.util.ArrayList;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.com.fasterxml.jackson.core.filter.TokenFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.filtering.FilterPath;

public class FilterPathBasedFilter
extends TokenFilter {
    private static final TokenFilter MATCHING = new TokenFilter(){};
    private static final TokenFilter NO_MATCHING = new TokenFilter(){};
    private final FilterPath[] filters;
    private final boolean inclusive;

    public FilterPathBasedFilter(FilterPath[] filters, boolean inclusive) {
        if (filters == null || filters.length == 0) {
            throw new IllegalArgumentException("filters cannot be null or empty");
        }
        this.inclusive = inclusive;
        this.filters = filters;
    }

    public FilterPathBasedFilter(Set<String> filters, boolean inclusive) {
        this(FilterPath.compile(filters), inclusive);
    }

    private TokenFilter evaluate(String name, FilterPath[] filters) {
        if (filters != null) {
            ArrayList<FilterPath> nextFilters = null;
            for (FilterPath filter : filters) {
                FilterPath next = filter.matchProperty(name);
                if (next == null) continue;
                if (next.matches()) {
                    return MATCHING;
                }
                if (nextFilters == null) {
                    nextFilters = new ArrayList<FilterPath>();
                }
                if (filter.isDoubleWildcard()) {
                    nextFilters.add(filter);
                }
                nextFilters.add(next);
            }
            if (nextFilters != null && !nextFilters.isEmpty()) {
                return new FilterPathBasedFilter(nextFilters.toArray(new FilterPath[nextFilters.size()]), this.inclusive);
            }
        }
        return NO_MATCHING;
    }

    @Override
    public TokenFilter includeProperty(String name) {
        TokenFilter filter = this.evaluate(name, this.filters);
        if (filter == MATCHING) {
            return this.inclusive ? TokenFilter.INCLUDE_ALL : null;
        }
        if (filter == NO_MATCHING) {
            return this.inclusive ? null : TokenFilter.INCLUDE_ALL;
        }
        return filter;
    }

    @Override
    protected boolean _includeScalar() {
        return !this.inclusive;
    }
}

