/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentLocation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;

public class XContentSubParser
implements XContentParser {
    private final XContentParser parser;
    private int level;
    private boolean closed;

    public XContentSubParser(XContentParser parser) {
        this.parser = parser;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new IllegalStateException("The sub parser has to be created on the start of an object or array");
        }
        this.level = 1;
    }

    @Override
    public XContentType contentType() {
        return this.parser.contentType();
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        if (this.level > 0) {
            XContentParser.Token token = this.parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                ++this.level;
            } else if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                --this.level;
            }
            return token;
        }
        return null;
    }

    @Override
    public void skipChildren() throws IOException {
        XContentParser.Token token = this.parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT && token != XContentParser.Token.START_ARRAY) {
            return;
        }
        int backToLevel = this.level - 1;
        while (this.nextToken() != null) {
            if (this.level > backToLevel) continue;
            return;
        }
    }

    @Override
    public XContentParser.Token currentToken() {
        return this.parser.currentToken();
    }

    @Override
    public String currentName() throws IOException {
        return this.parser.currentName();
    }

    @Override
    public Map<String, Object> map() throws IOException {
        return this.parser.map();
    }

    @Override
    public Map<String, Object> mapOrdered() throws IOException {
        return this.parser.mapOrdered();
    }

    @Override
    public Map<String, String> mapStrings() throws IOException {
        return this.parser.mapStrings();
    }

    @Override
    public <T> Map<String, T> map(Supplier<Map<String, T>> mapFactory, CheckedFunction<XContentParser, T, IOException> mapValueParser) throws IOException {
        return this.parser.map(mapFactory, mapValueParser);
    }

    @Override
    public List<Object> list() throws IOException {
        return this.parser.list();
    }

    @Override
    public List<Object> listOrderedMap() throws IOException {
        return this.parser.listOrderedMap();
    }

    @Override
    public String text() throws IOException {
        return this.parser.text();
    }

    @Override
    public String textOrNull() throws IOException {
        return this.parser.textOrNull();
    }

    @Override
    public CharBuffer charBufferOrNull() throws IOException {
        return this.parser.charBufferOrNull();
    }

    @Override
    public CharBuffer charBuffer() throws IOException {
        return this.parser.charBuffer();
    }

    @Override
    public Object objectText() throws IOException {
        return this.parser.objectText();
    }

    @Override
    public Object objectBytes() throws IOException {
        return this.parser.objectBytes();
    }

    @Override
    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    @Override
    public char[] textCharacters() throws IOException {
        return this.parser.textCharacters();
    }

    @Override
    public int textLength() throws IOException {
        return this.parser.textLength();
    }

    @Override
    public int textOffset() throws IOException {
        return this.parser.textOffset();
    }

    @Override
    public Number numberValue() throws IOException {
        return this.parser.numberValue();
    }

    @Override
    public XContentParser.NumberType numberType() throws IOException {
        return this.parser.numberType();
    }

    @Override
    public short shortValue(boolean coerce) throws IOException {
        return this.parser.shortValue(coerce);
    }

    @Override
    public int intValue(boolean coerce) throws IOException {
        return this.parser.intValue(coerce);
    }

    @Override
    public long longValue(boolean coerce) throws IOException {
        return this.parser.longValue(coerce);
    }

    @Override
    public float floatValue(boolean coerce) throws IOException {
        return this.parser.floatValue(coerce);
    }

    @Override
    public double doubleValue(boolean coerce) throws IOException {
        return this.parser.doubleValue();
    }

    @Override
    public short shortValue() throws IOException {
        return this.parser.shortValue();
    }

    @Override
    public int intValue() throws IOException {
        return this.parser.intValue();
    }

    @Override
    public long longValue() throws IOException {
        return this.parser.longValue();
    }

    @Override
    public float floatValue() throws IOException {
        return this.parser.floatValue();
    }

    @Override
    public double doubleValue() throws IOException {
        return this.parser.doubleValue();
    }

    @Override
    public boolean isBooleanValue() throws IOException {
        return this.parser.isBooleanValue();
    }

    @Override
    public boolean booleanValue() throws IOException {
        return this.parser.booleanValue();
    }

    @Override
    public byte[] binaryValue() throws IOException {
        return this.parser.binaryValue();
    }

    @Override
    public XContentLocation getTokenLocation() {
        return this.parser.getTokenLocation();
    }

    @Override
    public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
        return this.parser.namedObject(categoryClass, name, context);
    }

    @Override
    public NamedXContentRegistry getXContentRegistry() {
        return this.parser.getXContentRegistry();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DeprecationHandler getDeprecationHandler() {
        return this.parser.getDeprecationHandler();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            while (this.nextToken() != null) {
            }
            return;
        }
    }
}

