/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.logging.log4j.LogManager;

public class LoggingDeprecationHandler
implements DeprecationHandler {
    public static LoggingDeprecationHandler INSTANCE = new LoggingDeprecationHandler();
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(ParseField.class));

    private LoggingDeprecationHandler() {
    }

    @Override
    public void usedDeprecatedName(String usedName, String modernName) {
        deprecationLogger.deprecated("Deprecated field [{}] used, expected [{}] instead", usedName, modernName);
    }

    @Override
    public void usedDeprecatedField(String usedName, String replacedWith) {
        deprecationLogger.deprecated("Deprecated field [{}] used, replaced by [{}]", usedName, replacedWith);
    }
}

