/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.core.internal.io.IOUtils;

public enum Releasables {


    private static void close(Iterable<? extends Releasable> releasables, boolean ignoreException) {
        block2: {
            try {
                IOUtils.close(releasables);
            }
            catch (IOException e) {
                if (ignoreException) break block2;
                throw new UncheckedIOException(e);
            }
        }
    }

    public static void close(Iterable<? extends Releasable> releasables) {
        Releasables.close(releasables, false);
    }

    public static void close(Releasable ... releasables) {
        Releasables.close(Arrays.asList(releasables));
    }

    public static void closeWhileHandlingException(Iterable<Releasable> releasables) {
        Releasables.close(releasables, true);
    }

    public static void closeWhileHandlingException(Releasable ... releasables) {
        Releasables.closeWhileHandlingException(Arrays.asList(releasables));
    }

    public static void close(boolean success, Iterable<Releasable> releasables) {
        if (success) {
            Releasables.close(releasables);
        } else {
            Releasables.closeWhileHandlingException(releasables);
        }
    }

    public static void close(boolean success, Releasable ... releasables) {
        Releasables.close(success, Arrays.asList(releasables));
    }

    public static Releasable wrap(Iterable<Releasable> releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable wrap(Releasable ... releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable releaseOnce(Releasable ... releasables) {
        AtomicBoolean released = new AtomicBoolean(false);
        return () -> {
            if (released.compareAndSet(false, true)) {
                Releasables.close(releasables);
            }
        };
    }
}

