/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common;

import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.SuppressForbidden;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;

public final class Randomness {
    private static final Method currentMethod;
    private static final Method getRandomMethod;

    private Randomness() {
    }

    public static Random get(Settings settings, Setting<Long> setting) {
        if (setting.exists(settings)) {
            return new Random(setting.get(settings));
        }
        return Randomness.get();
    }

    public static Random get() {
        if (currentMethod != null && getRandomMethod != null) {
            try {
                Object randomizedContext = currentMethod.invoke(null, new Object[0]);
                return (Random)getRandomMethod.invoke(randomizedContext, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("running tests but failed to invoke RandomizedContext#getRandom", e);
            }
        }
        return Randomness.getWithoutSeed();
    }

    public static SecureRandom createSecure() {
        if (currentMethod != null && getRandomMethod != null) {
            byte[] seed = new byte[16];
            Randomness.get().nextBytes(seed);
            return new SecureRandom(seed);
        }
        return new SecureRandom();
    }

    @SuppressForbidden(reason="ThreadLocalRandom is okay when not running tests")
    private static Random getWithoutSeed() {
        assert (currentMethod == null && getRandomMethod == null) : "running under tests but tried to create non-reproducible random";
        return ThreadLocalRandom.current();
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list, Randomness.get());
    }

    static {
        Method maybeGetRandomMethod;
        Method maybeCurrentMethod;
        try {
            Class<?> clazz = Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
            maybeCurrentMethod = clazz.getMethod("current", new Class[0]);
            maybeGetRandomMethod = clazz.getMethod("getRandom", new Class[0]);
        }
        catch (Exception e) {
            maybeCurrentMethod = null;
            maybeGetRandomMethod = null;
        }
        currentMethod = maybeCurrentMethod;
        getRandomMethod = maybeGetRandomMethod;
    }
}

