/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.LongArrayList;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.IntObjectCursor;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Assertions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActiveShardCount;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.AbstractDiffable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.Diff;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.Diffable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.DiffableUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlock;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.AliasMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.DiffableStringMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MappingMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.MapBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.compress.CompressedXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.MetaDataStateFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public class IndexMetaData
implements Diffable<IndexMetaData>,
ToXContentFragment {
    public static final ClusterBlock INDEX_READ_ONLY_BLOCK = new ClusterBlock(5, "index read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock INDEX_READ_BLOCK = new ClusterBlock(7, "index read (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.READ));
    public static final ClusterBlock INDEX_WRITE_BLOCK = new ClusterBlock(8, "index write (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final ClusterBlock INDEX_METADATA_BLOCK = new ClusterBlock(9, "index metadata (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.METADATA_READ));
    public static final ClusterBlock INDEX_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(12, "index read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.WRITE));
    public static final String INDEX_SETTING_PREFIX = "index.";
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final Setting<Integer> INDEX_NUMBER_OF_SHARDS_SETTING = IndexMetaData.buildNumberOfShardsSetting();
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final Setting<Integer> INDEX_NUMBER_OF_REPLICAS_SETTING = Setting.intSetting("index.number_of_replicas", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_ROUTING_PARTITION_SIZE = "index.routing_partition_size";
    public static final Setting<Integer> INDEX_ROUTING_PARTITION_SIZE_SETTING = Setting.intSetting("index.routing_partition_size", 1, 1, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING = Setting.intSetting("index.number_of_routing_shards", INDEX_NUMBER_OF_SHARDS_SETTING, 1, new Setting.Validator<Integer>(){

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer numRoutingShards, Map<Setting<?>, Object> settings) {
            int numShards = (Integer)settings.get(INDEX_NUMBER_OF_SHARDS_SETTING);
            if (numRoutingShards < numShards) {
                throw new IllegalArgumentException("index.number_of_routing_shards [" + numRoutingShards + "] must be >= index.number_of_shards [" + numShards + "]");
            }
            IndexMetaData.getRoutingFactor(numShards, numRoutingShards);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(INDEX_NUMBER_OF_SHARDS_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope);
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    public static final Setting<AutoExpandReplicas> INDEX_AUTO_EXPAND_REPLICAS_SETTING = AutoExpandReplicas.SETTING;
    public static final String SETTING_READ_ONLY = "index.blocks.read_only";
    public static final Setting<Boolean> INDEX_READ_ONLY_SETTING = Setting.boolSetting("index.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_READ = "index.blocks.read";
    public static final Setting<Boolean> INDEX_BLOCKS_READ_SETTING = Setting.boolSetting("index.blocks.read", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_WRITE = "index.blocks.write";
    public static final Setting<Boolean> INDEX_BLOCKS_WRITE_SETTING = Setting.boolSetting("index.blocks.write", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_METADATA = "index.blocks.metadata";
    public static final Setting<Boolean> INDEX_BLOCKS_METADATA_SETTING = Setting.boolSetting("index.blocks.metadata", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_READ_ONLY_ALLOW_DELETE = "index.blocks.read_only_allow_delete";
    public static final Setting<Boolean> INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("index.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_VERSION_CREATED = "index.version.created";
    public static final Setting<Version> SETTING_INDEX_VERSION_CREATED = Setting.versionSetting("index.version.created", Version.V_EMPTY, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    public static final String SETTING_VERSION_CREATED_STRING = "index.version.created_string";
    public static final String SETTING_VERSION_UPGRADED = "index.version.upgraded";
    public static final String SETTING_VERSION_UPGRADED_STRING = "index.version.upgraded_string";
    public static final String SETTING_CREATION_DATE = "index.creation_date";
    public static final String SETTING_INDEX_PROVIDED_NAME = "index.provided_name";
    public static final String SETTING_PRIORITY = "index.priority";
    public static final Setting<Integer> INDEX_PRIORITY_SETTING = Setting.intSetting("index.priority", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_CREATION_DATE_STRING = "index.creation_date_string";
    public static final String SETTING_INDEX_UUID = "index.uuid";
    public static final String SETTING_DATA_PATH = "index.data_path";
    public static final Setting<String> INDEX_DATA_PATH_SETTING = new Setting("index.data_path", "", Function.identity(), Setting.Property.IndexScope);
    public static final String INDEX_UUID_NA_VALUE = "_na_";
    public static final String INDEX_ROUTING_REQUIRE_GROUP_PREFIX = "index.routing.allocation.require";
    public static final String INDEX_ROUTING_INCLUDE_GROUP_PREFIX = "index.routing.allocation.include";
    public static final String INDEX_ROUTING_EXCLUDE_GROUP_PREFIX = "index.routing.allocation.exclude";
    public static final Setting.AffixSetting<String> INDEX_ROUTING_REQUIRE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.require.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.include.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_EXCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.exclude.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.initial_recovery.", key -> Setting.simpleString(key, new Setting.Property[0]));
    public static final Setting<ActiveShardCount> SETTING_WAIT_FOR_ACTIVE_SHARDS = new Setting<ActiveShardCount>("index.write.wait_for_active_shards", "1", ActiveShardCount::parseString, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final String INDEX_FORMAT = "index.format";
    public static final Setting<Integer> INDEX_FORMAT_SETTING = Setting.intSetting("index.format", 0, Setting.Property.IndexScope, Setting.Property.Final);
    public static final String KEY_IN_SYNC_ALLOCATIONS = "in_sync_allocations";
    static final String KEY_VERSION = "version";
    static final String KEY_MAPPING_VERSION = "mapping_version";
    static final String KEY_SETTINGS_VERSION = "settings_version";
    static final String KEY_ALIASES_VERSION = "aliases_version";
    static final String KEY_ROUTING_NUM_SHARDS = "routing_num_shards";
    static final String KEY_SETTINGS = "settings";
    static final String KEY_STATE = "state";
    static final String KEY_MAPPINGS = "mappings";
    static final String KEY_ALIASES = "aliases";
    static final String KEY_ROLLOVER_INFOS = "rollover_info";
    public static final String KEY_PRIMARY_TERMS = "primary_terms";
    public static final String INDEX_STATE_FILE_PREFIX = "state-";
    private final int routingNumShards;
    private final int routingFactor;
    private final int routingPartitionSize;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final Index index;
    private final long version;
    private final long mappingVersion;
    private final long settingsVersion;
    private final long aliasesVersion;
    private final long[] primaryTerms;
    private final State state;
    private final ImmutableOpenMap<String, AliasMetaData> aliases;
    private final Settings settings;
    private final ImmutableOpenMap<String, MappingMetaData> mappings;
    private final ImmutableOpenMap<String, DiffableStringMap> customData;
    private final ImmutableOpenIntMap<Set<String>> inSyncAllocationIds;
    private final transient int totalNumberOfShards;
    private final DiscoveryNodeFilters requireFilters;
    private final DiscoveryNodeFilters includeFilters;
    private final DiscoveryNodeFilters excludeFilters;
    private final DiscoveryNodeFilters initialRecoveryFilters;
    private final Version indexCreatedVersion;
    private final Version indexUpgradedVersion;
    private final ActiveShardCount waitForActiveShards;
    private final ImmutableOpenMap<String, RolloverInfo> rolloverInfos;
    public static final String INDEX_RESIZE_SOURCE_UUID_KEY = "index.resize.source.uuid";
    public static final String INDEX_RESIZE_SOURCE_NAME_KEY = "index.resize.source.name";
    public static final Setting<String> INDEX_RESIZE_SOURCE_UUID = Setting.simpleString("index.resize.source.uuid", new Setting.Property[0]);
    public static final Setting<String> INDEX_RESIZE_SOURCE_NAME = Setting.simpleString("index.resize.source.name", new Setting.Property[0]);
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("binary", "true"));
    public static final MetaDataStateFormat<IndexMetaData> FORMAT = new MetaDataStateFormat<IndexMetaData>("state-"){

        @Override
        public void toXContent(XContentBuilder builder, IndexMetaData state) throws IOException {
            Builder.toXContent(state, builder, FORMAT_PARAMS);
        }

        @Override
        public IndexMetaData fromXContent(XContentParser parser) throws IOException {
            return Builder.fromXContent(parser);
        }
    };

    static Setting<Integer> buildNumberOfShardsSetting() {
        int maxNumShards = Integer.parseInt(System.getProperty("es.index.max_number_of_shards", "1024"));
        if (maxNumShards < 1) {
            throw new IllegalArgumentException("es.index.max_number_of_shards must be > 0");
        }
        return Setting.intSetting(SETTING_NUMBER_OF_SHARDS, 1, 1, maxNumShards, Setting.Property.IndexScope, Setting.Property.Final);
    }

    private IndexMetaData(Index index, long version, long mappingVersion, long settingsVersion, long aliasesVersion, long[] primaryTerms, State state, int numberOfShards, int numberOfReplicas, Settings settings, ImmutableOpenMap<String, MappingMetaData> mappings, ImmutableOpenMap<String, AliasMetaData> aliases, ImmutableOpenMap<String, DiffableStringMap> customData, ImmutableOpenIntMap<Set<String>> inSyncAllocationIds, DiscoveryNodeFilters requireFilters, DiscoveryNodeFilters initialRecoveryFilters, DiscoveryNodeFilters includeFilters, DiscoveryNodeFilters excludeFilters, Version indexCreatedVersion, Version indexUpgradedVersion, int routingNumShards, int routingPartitionSize, ActiveShardCount waitForActiveShards, ImmutableOpenMap<String, RolloverInfo> rolloverInfos) {
        this.index = index;
        this.version = version;
        assert (mappingVersion >= 0L) : mappingVersion;
        this.mappingVersion = mappingVersion;
        assert (settingsVersion >= 0L) : settingsVersion;
        this.settingsVersion = settingsVersion;
        assert (aliasesVersion >= 0L) : aliasesVersion;
        this.aliasesVersion = aliasesVersion;
        this.primaryTerms = primaryTerms;
        assert (primaryTerms.length == numberOfShards);
        this.state = state;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.totalNumberOfShards = numberOfShards * (numberOfReplicas + 1);
        this.settings = settings;
        this.mappings = mappings;
        this.customData = customData;
        this.aliases = aliases;
        this.inSyncAllocationIds = inSyncAllocationIds;
        this.requireFilters = requireFilters;
        this.includeFilters = includeFilters;
        this.excludeFilters = excludeFilters;
        this.initialRecoveryFilters = initialRecoveryFilters;
        this.indexCreatedVersion = indexCreatedVersion;
        this.indexUpgradedVersion = indexUpgradedVersion;
        this.routingNumShards = routingNumShards;
        this.routingFactor = routingNumShards / numberOfShards;
        this.routingPartitionSize = routingPartitionSize;
        this.waitForActiveShards = waitForActiveShards;
        this.rolloverInfos = rolloverInfos;
        assert (numberOfShards * this.routingFactor == routingNumShards) : routingNumShards + " must be a multiple of " + numberOfShards;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getIndexUUID() {
        return this.index.getUUID();
    }

    public boolean isSameUUID(String otherUUID) {
        assert (otherUUID != null);
        assert (this.getIndexUUID() != null);
        if (INDEX_UUID_NA_VALUE.equals(otherUUID) || INDEX_UUID_NA_VALUE.equals(this.getIndexUUID())) {
            return true;
        }
        return otherUUID.equals(this.getIndexUUID());
    }

    public long getVersion() {
        return this.version;
    }

    public long getMappingVersion() {
        return this.mappingVersion;
    }

    public long getSettingsVersion() {
        return this.settingsVersion;
    }

    public long getAliasesVersion() {
        return this.aliasesVersion;
    }

    public long primaryTerm(int shardId) {
        return this.primaryTerms[shardId];
    }

    public Version getCreationVersion() {
        return this.indexCreatedVersion;
    }

    public Version getUpgradedVersion() {
        return this.indexUpgradedVersion;
    }

    public long getCreationDate() {
        return this.settings.getAsLong(SETTING_CREATION_DATE, -1L);
    }

    public State getState() {
        return this.state;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getRoutingPartitionSize() {
        return this.routingPartitionSize;
    }

    public boolean isRoutingPartitionedIndex() {
        return this.routingPartitionSize != 1;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, AliasMetaData> getAliases() {
        return this.aliases;
    }

    @Deprecated
    public ImmutableOpenMap<String, MappingMetaData> getMappings() {
        return this.mappings;
    }

    @Nullable
    public MappingMetaData mapping() {
        for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : this.mappings) {
            if (((String)objectObjectCursor.key).equals("_default_")) continue;
            return (MappingMetaData)objectObjectCursor.value;
        }
        return null;
    }

    @Nullable
    public MappingMetaData defaultMapping() {
        return this.mappings.get("_default_");
    }

    public Index getResizeSourceIndex() {
        return INDEX_RESIZE_SOURCE_UUID.exists(this.settings) ? new Index(INDEX_RESIZE_SOURCE_NAME.get(this.settings), INDEX_RESIZE_SOURCE_UUID.get(this.settings)) : null;
    }

    @Nullable
    public MappingMetaData mappingOrDefault() {
        MappingMetaData mapping = null;
        for (ObjectCursor<MappingMetaData> objectCursor : this.mappings.values()) {
            if (mapping != null && !mapping.type().equals("_default_")) continue;
            mapping = (MappingMetaData)objectCursor.value;
        }
        return mapping;
    }

    ImmutableOpenMap<String, DiffableStringMap> getCustomData() {
        return this.customData;
    }

    public Map<String, String> getCustomData(String key) {
        return this.customData.get(key);
    }

    public ImmutableOpenIntMap<Set<String>> getInSyncAllocationIds() {
        return this.inSyncAllocationIds;
    }

    public ImmutableOpenMap<String, RolloverInfo> getRolloverInfos() {
        return this.rolloverInfos;
    }

    public Set<String> inSyncAllocationIds(int shardId) {
        assert (shardId >= 0 && shardId < this.numberOfShards);
        return this.inSyncAllocationIds.get(shardId);
    }

    @Nullable
    public DiscoveryNodeFilters requireFilters() {
        return this.requireFilters;
    }

    @Nullable
    public DiscoveryNodeFilters getInitialRecoveryFilters() {
        return this.initialRecoveryFilters;
    }

    @Nullable
    public DiscoveryNodeFilters includeFilters() {
        return this.includeFilters;
    }

    @Nullable
    public DiscoveryNodeFilters excludeFilters() {
        return this.excludeFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMetaData that = (IndexMetaData)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (!this.customData.equals(that.customData)) {
            return false;
        }
        if (this.routingNumShards != that.routingNumShards) {
            return false;
        }
        if (this.routingFactor != that.routingFactor) {
            return false;
        }
        if (!Arrays.equals(this.primaryTerms, that.primaryTerms)) {
            return false;
        }
        if (!this.inSyncAllocationIds.equals(that.inSyncAllocationIds)) {
            return false;
        }
        return this.rolloverInfos.equals(that.rolloverInfos);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + Long.hashCode(this.version);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        result = 31 * result + this.customData.hashCode();
        result = 31 * result + Long.hashCode(this.routingFactor);
        result = 31 * result + Long.hashCode(this.routingNumShards);
        result = 31 * result + Arrays.hashCode(this.primaryTerms);
        result = 31 * result + this.inSyncAllocationIds.hashCode();
        result = 31 * result + this.rolloverInfos.hashCode();
        return result;
    }

    @Override
    public Diff<IndexMetaData> diff(IndexMetaData previousState) {
        return new IndexMetaDataDiff(previousState, this);
    }

    public static Diff<IndexMetaData> readDiffFrom(StreamInput in) throws IOException {
        return new IndexMetaDataDiff(in);
    }

    public static IndexMetaData fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static IndexMetaData readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.version(in.readLong());
        if (in.getVersion().onOrAfter(Version.V_6_5_0)) {
            builder.mappingVersion(in.readVLong());
        } else {
            builder.mappingVersion(1L);
        }
        if (in.getVersion().onOrAfter(Version.V_6_5_0)) {
            builder.settingsVersion(in.readVLong());
        } else {
            builder.settingsVersion(1L);
        }
        if (in.getVersion().onOrAfter(Version.V_7_2_0)) {
            builder.aliasesVersion(in.readVLong());
        } else {
            builder.aliasesVersion(1L);
        }
        builder.setRoutingNumShards(in.readInt());
        builder.state(State.fromId(in.readByte()));
        builder.settings(Settings.readSettingsFromStream(in));
        builder.primaryTerms(in.readVLongArray());
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            MappingMetaData mappingMd = new MappingMetaData(in);
            builder.putMapping(mappingMd);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetaData aliasMd = new AliasMetaData(in);
            builder.putAlias(aliasMd);
        }
        int customSize = in.readVInt();
        if (in.getVersion().onOrAfter(Version.V_6_5_0)) {
            for (int i = 0; i < customSize; ++i) {
                String key = in.readString();
                DiffableStringMap custom = new DiffableStringMap(in);
                builder.putCustom(key, custom);
            }
        } else {
            assert (customSize == 0) : "expected no custom index metadata";
            if (customSize > 0) {
                throw new IllegalStateException("unexpected custom metadata when none is supported");
            }
        }
        int inSyncAllocationIdsSize = in.readVInt();
        for (int i = 0; i < inSyncAllocationIdsSize; ++i) {
            int key = in.readVInt();
            Object allocationIds = DiffableUtils.StringSetValueSerializer.getInstance().read(in, (Object)key);
            builder.putInSyncAllocationIds(key, (Set<String>)allocationIds);
        }
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            int rolloverAliasesSize = in.readVInt();
            for (int i = 0; i < rolloverAliasesSize; ++i) {
                builder.putRolloverInfo(new RolloverInfo(in));
            }
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index.getName());
        out.writeLong(this.version);
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeVLong(this.mappingVersion);
        }
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeVLong(this.settingsVersion);
        }
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeVLong(this.aliasesVersion);
        }
        out.writeInt(this.routingNumShards);
        out.writeByte(this.state.id());
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVLongArray(this.primaryTerms);
        out.writeVInt(this.mappings.size());
        for (ObjectCursor<MappingMetaData> objectCursor : this.mappings.values()) {
            ((MappingMetaData)objectCursor.value).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (ObjectCursor<AbstractDiffable> objectCursor : this.aliases.values()) {
            ((AliasMetaData)objectCursor.value).writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeVInt(this.customData.size());
            for (ObjectObjectCursor objectObjectCursor : this.customData) {
                out.writeString((String)objectObjectCursor.key);
                ((DiffableStringMap)objectObjectCursor.value).writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeVInt(this.inSyncAllocationIds.size());
        for (IntObjectCursor intObjectCursor : this.inSyncAllocationIds) {
            out.writeVInt(intObjectCursor.key);
            DiffableUtils.StringSetValueSerializer.getInstance().write((Set)intObjectCursor.value, out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeVInt(this.rolloverInfos.size());
            for (ObjectCursor objectCursor : this.rolloverInfos.values()) {
                ((RolloverInfo)objectCursor.value).writeTo(out);
            }
        }
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public static Builder builder(IndexMetaData indexMetaData) {
        return new Builder(indexMetaData);
    }

    public static Settings addHumanReadableSettings(Settings settings) {
        Long creationDate;
        Version versionUpgraded;
        Settings.Builder builder = Settings.builder().put(settings);
        Version version = SETTING_INDEX_VERSION_CREATED.get(settings);
        if (version != Version.V_EMPTY) {
            builder.put(SETTING_VERSION_CREATED_STRING, version.toString());
        }
        if ((versionUpgraded = settings.getAsVersion(SETTING_VERSION_UPGRADED, null)) != null) {
            builder.put(SETTING_VERSION_UPGRADED_STRING, versionUpgraded.toString());
        }
        if ((creationDate = settings.getAsLong(SETTING_CREATION_DATE, null)) != null) {
            ZonedDateTime creationDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(creationDate), ZoneOffset.UTC);
            builder.put(SETTING_CREATION_DATE_STRING, creationDateTime.toString());
        }
        return builder.build();
    }

    public int getRoutingNumShards() {
        return this.routingNumShards;
    }

    public int getRoutingFactor() {
        return this.routingFactor;
    }

    public static ShardId selectSplitShard(int shardId, IndexMetaData sourceIndexMetadata, int numTargetShards) {
        int numSourceShards = sourceIndexMetadata.getNumberOfShards();
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        int routingFactor = IndexMetaData.getRoutingFactor(numSourceShards, numTargetShards);
        IndexMetaData.assertSplitMetadata(numSourceShards, numTargetShards, sourceIndexMetadata);
        return new ShardId(sourceIndexMetadata.getIndex(), shardId / routingFactor);
    }

    public static ShardId selectCloneShard(int shardId, IndexMetaData sourceIndexMetadata, int numTargetShards) {
        int numSourceShards = sourceIndexMetadata.getNumberOfShards();
        if (numSourceShards != numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be the same as the number of  source shards ( " + numSourceShards + ")");
        }
        return new ShardId(sourceIndexMetadata.getIndex(), shardId);
    }

    private static void assertSplitMetadata(int numSourceShards, int numTargetShards, IndexMetaData sourceIndexMetadata) {
        int routingNumShards;
        if (numSourceShards > numTargetShards) {
            throw new IllegalArgumentException("the number of source shards [" + numSourceShards + "] must be less that the number of target shards [" + numTargetShards + "]");
        }
        int n = routingNumShards = numSourceShards == 1 ? numTargetShards : sourceIndexMetadata.getRoutingNumShards();
        if (routingNumShards % numTargetShards != 0) {
            throw new IllegalStateException("the number of routing shards [" + routingNumShards + "] must be a multiple of the target shards [" + numTargetShards + "]");
        }
        assert (sourceIndexMetadata.getNumberOfShards() == 1 || IndexMetaData.getRoutingFactor(numTargetShards, routingNumShards) >= 0);
    }

    public static Set<ShardId> selectRecoverFromShards(int shardId, IndexMetaData sourceIndexMetadata, int numTargetShards) {
        if (sourceIndexMetadata.getNumberOfShards() > numTargetShards) {
            return IndexMetaData.selectShrinkShards(shardId, sourceIndexMetadata, numTargetShards);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            return Collections.singleton(IndexMetaData.selectSplitShard(shardId, sourceIndexMetadata, numTargetShards));
        }
        return Collections.singleton(IndexMetaData.selectCloneShard(shardId, sourceIndexMetadata, numTargetShards));
    }

    public static Set<ShardId> selectShrinkShards(int shardId, IndexMetaData sourceIndexMetadata, int numTargetShards) {
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            throw new IllegalArgumentException("the number of target shards [" + numTargetShards + "] must be less that the number of source shards [" + sourceIndexMetadata.getNumberOfShards() + "]");
        }
        int routingFactor = IndexMetaData.getRoutingFactor(sourceIndexMetadata.getNumberOfShards(), numTargetShards);
        HashSet<ShardId> shards = new HashSet<ShardId>(routingFactor);
        for (int i = shardId * routingFactor; i < routingFactor * shardId + routingFactor; ++i) {
            shards.add(new ShardId(sourceIndexMetadata.getIndex(), i));
        }
        return shards;
    }

    public static int getRoutingFactor(int sourceNumberOfShards, int targetNumberOfShards) {
        int factor;
        if (sourceNumberOfShards < targetNumberOfShards) {
            factor = targetNumberOfShards / sourceNumberOfShards;
            if (factor * sourceNumberOfShards != targetNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a factor of [" + targetNumberOfShards + "]");
            }
        } else if (sourceNumberOfShards > targetNumberOfShards) {
            factor = sourceNumberOfShards / targetNumberOfShards;
            if (factor * targetNumberOfShards != sourceNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a multiple of [" + targetNumberOfShards + "]");
            }
        } else {
            factor = 1;
        }
        return factor;
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private long version = 1L;
        private long mappingVersion = 1L;
        private long settingsVersion = 1L;
        private long aliasesVersion = 1L;
        private long[] primaryTerms = null;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, MappingMetaData> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetaData> aliases;
        private final ImmutableOpenMap.Builder<String, DiffableStringMap> customMetaData;
        private final ImmutableOpenIntMap.Builder<Set<String>> inSyncAllocationIds;
        private final ImmutableOpenMap.Builder<String, RolloverInfo> rolloverInfos;
        private Integer routingNumShards;

        public Builder(String index) {
            this.index = index;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
            this.customMetaData = ImmutableOpenMap.builder();
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder();
            this.rolloverInfos = ImmutableOpenMap.builder();
        }

        public Builder(IndexMetaData indexMetaData) {
            this.index = indexMetaData.getIndex().getName();
            this.state = indexMetaData.state;
            this.version = indexMetaData.version;
            this.mappingVersion = indexMetaData.mappingVersion;
            this.settingsVersion = indexMetaData.settingsVersion;
            this.aliasesVersion = indexMetaData.aliasesVersion;
            this.settings = indexMetaData.getSettings();
            this.primaryTerms = (long[])indexMetaData.primaryTerms.clone();
            this.mappings = ImmutableOpenMap.builder(indexMetaData.mappings);
            this.aliases = ImmutableOpenMap.builder(indexMetaData.aliases);
            this.customMetaData = ImmutableOpenMap.builder(indexMetaData.customData);
            this.routingNumShards = indexMetaData.routingNumShards;
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder(indexMetaData.inSyncAllocationIds);
            this.rolloverInfos = ImmutableOpenMap.builder(indexMetaData.rolloverInfos);
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public Builder setRoutingNumShards(int routingNumShards) {
            this.routingNumShards = routingNumShards;
            return this;
        }

        public int getRoutingNumShards() {
            return this.routingNumShards == null ? this.numberOfShards() : this.routingNumShards.intValue();
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_SHARDS, -1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public Builder routingPartitionSize(int routingPartitionSize) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetaData.SETTING_ROUTING_PARTITION_SIZE, routingPartitionSize).build();
            return this;
        }

        public Builder creationDate(long creationDate) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetaData.SETTING_CREATION_DATE, creationDate).build();
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            return this.settings(settings.build());
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public MappingMetaData mapping(String type) {
            return this.mappings.get(type);
        }

        public Builder putMapping(String type, String source) throws IOException {
            this.putMapping(new MappingMetaData(type, XContentHelper.convertToMap(XContentFactory.xContent(source), source, true)));
            return this;
        }

        public Builder putMapping(MappingMetaData mappingMd) {
            this.mappings.put(mappingMd.type(), mappingMd);
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder putAlias(AliasMetaData aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData);
            return this;
        }

        public Builder putAlias(AliasMetaData.Builder aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData.build());
            return this;
        }

        public Builder removeAlias(String alias) {
            this.aliases.remove(alias);
            return this;
        }

        public Builder removeAllAliases() {
            this.aliases.clear();
            return this;
        }

        public Builder putCustom(String type, Map<String, String> customIndexMetaData) {
            this.customMetaData.put(type, new DiffableStringMap(customIndexMetaData));
            return this;
        }

        public Map<String, String> removeCustom(String type) {
            return this.customMetaData.remove(type);
        }

        public Set<String> getInSyncAllocationIds(int shardId) {
            return this.inSyncAllocationIds.get(shardId);
        }

        public Builder putInSyncAllocationIds(int shardId, Set<String> allocationIds) {
            this.inSyncAllocationIds.put(shardId, new HashSet<String>(allocationIds));
            return this;
        }

        public Builder putRolloverInfo(RolloverInfo rolloverInfo) {
            this.rolloverInfos.put(rolloverInfo.getAlias(), rolloverInfo);
            return this;
        }

        public long version() {
            return this.version;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public long mappingVersion() {
            return this.mappingVersion;
        }

        public Builder mappingVersion(long mappingVersion) {
            this.mappingVersion = mappingVersion;
            return this;
        }

        public long settingsVersion() {
            return this.settingsVersion;
        }

        public Builder settingsVersion(long settingsVersion) {
            this.settingsVersion = settingsVersion;
            return this;
        }

        public long aliasesVersion() {
            return this.aliasesVersion;
        }

        public Builder aliasesVersion(long aliasesVersion) {
            this.aliasesVersion = aliasesVersion;
            return this;
        }

        public long primaryTerm(int shardId) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            return this.primaryTerms[shardId];
        }

        public Builder primaryTerm(int shardId, long primaryTerm) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            this.primaryTerms[shardId] = primaryTerm;
            return this;
        }

        private void primaryTerms(long[] primaryTerms) {
            this.primaryTerms = (long[])primaryTerms.clone();
        }

        private void initializePrimaryTerms() {
            assert (this.primaryTerms == null);
            if (this.numberOfShards() < 0) {
                throw new IllegalStateException("you must set the number of shards before setting/reading primary terms");
            }
            this.primaryTerms = new long[this.numberOfShards()];
            Arrays.fill(this.primaryTerms, 0L);
        }

        public IndexMetaData build() {
            Integer maybeNumberOfShards;
            ImmutableOpenMap.Builder<String, AliasMetaData> tmpAliases = this.aliases;
            Settings tmpSettings = this.settings;
            if (this.mappings.containsKey("_default_")) {
                MappingMetaData defaultMapping = this.mappings.get("_default_");
                for (ObjectCursor<MappingMetaData> objectCursor : this.mappings.values()) {
                    ((MappingMetaData)objectCursor.value).updateDefaultMapping(defaultMapping);
                }
            }
            if ((maybeNumberOfShards = this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_SHARDS, null)) == null) {
                throw new IllegalArgumentException("must specify numberOfShards for index [" + this.index + "]");
            }
            int numberOfShards = maybeNumberOfShards;
            if (numberOfShards <= 0) {
                throw new IllegalArgumentException("must specify positive number of shards for index [" + this.index + "]");
            }
            Integer n = this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, null);
            if (n == null) {
                throw new IllegalArgumentException("must specify numberOfReplicas for index [" + this.index + "]");
            }
            int numberOfReplicas = n;
            if (numberOfReplicas < 0) {
                throw new IllegalArgumentException("must specify non-negative number of replicas for index [" + this.index + "]");
            }
            int routingPartitionSize = INDEX_ROUTING_PARTITION_SIZE_SETTING.get(this.settings);
            if (routingPartitionSize != 1 && routingPartitionSize >= this.getRoutingNumShards()) {
                throw new IllegalArgumentException("routing partition size [" + routingPartitionSize + "] should be a positive number less than the number of shards [" + this.getRoutingNumShards() + "] for [" + this.index + "]");
            }
            ImmutableOpenIntMap.Builder filledInSyncAllocationIds = ImmutableOpenIntMap.builder();
            for (int i = 0; i < numberOfShards; ++i) {
                if (this.inSyncAllocationIds.containsKey(i)) {
                    filledInSyncAllocationIds.put(i, Collections.unmodifiableSet(new HashSet(this.inSyncAllocationIds.get(i))));
                    continue;
                }
                filledInSyncAllocationIds.put(i, Collections.emptySet());
            }
            Map<String, String> requireMap = INDEX_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters requireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
            Map<String, String> includeMap = INDEX_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters includeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
            Map<String, String> excludeMap = INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters excludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
            Map<String, String> initialRecoveryMap = INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters initialRecoveryFilters = initialRecoveryMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, initialRecoveryMap);
            Version indexCreatedVersion = Version.indexCreated(this.settings);
            Version indexUpgradedVersion = this.settings.getAsVersion(IndexMetaData.SETTING_VERSION_UPGRADED, indexCreatedVersion);
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            } else if (this.primaryTerms.length != numberOfShards) {
                throw new IllegalStateException("primaryTerms length is [" + this.primaryTerms.length + "] but should be equal to number of shards [" + this.numberOfShards() + "]");
            }
            ActiveShardCount waitForActiveShards = SETTING_WAIT_FOR_ACTIVE_SHARDS.get(this.settings);
            if (!waitForActiveShards.validate(numberOfReplicas)) {
                throw new IllegalArgumentException("invalid " + SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey() + "[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (numberOfReplicas + 1) + "]");
            }
            String uuid = this.settings.get(IndexMetaData.SETTING_INDEX_UUID, IndexMetaData.INDEX_UUID_NA_VALUE);
            return new IndexMetaData(new Index(this.index, uuid), this.version, this.mappingVersion, this.settingsVersion, this.aliasesVersion, this.primaryTerms, this.state, numberOfShards, numberOfReplicas, tmpSettings, this.mappings.build(), tmpAliases.build(), this.customMetaData.build(), filledInSyncAllocationIds.build(), requireFilters, initialRecoveryFilters, includeFilters, excludeFilters, indexCreatedVersion, indexUpgradedVersion, this.getRoutingNumShards(), routingPartitionSize, waitForActiveShards, this.rolloverInfos.build());
        }

        public static void toXContent(IndexMetaData indexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexMetaData.getIndex().getName());
            builder.field(IndexMetaData.KEY_VERSION, indexMetaData.getVersion());
            builder.field(IndexMetaData.KEY_MAPPING_VERSION, indexMetaData.getMappingVersion());
            builder.field(IndexMetaData.KEY_SETTINGS_VERSION, indexMetaData.getSettingsVersion());
            builder.field(IndexMetaData.KEY_ALIASES_VERSION, indexMetaData.getAliasesVersion());
            builder.field(IndexMetaData.KEY_ROUTING_NUM_SHARDS, indexMetaData.getRoutingNumShards());
            builder.field(IndexMetaData.KEY_STATE, indexMetaData.getState().toString().toLowerCase(Locale.ENGLISH));
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject(IndexMetaData.KEY_SETTINGS);
            indexMetaData.getSettings().toXContent(builder, new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
            builder.endObject();
            builder.startArray(IndexMetaData.KEY_MAPPINGS);
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.getMappings()) {
                if (binary) {
                    builder.value(((MappingMetaData)objectObjectCursor.value).source().compressed());
                    continue;
                }
                builder.map(XContentHelper.convertToMap(new BytesArray(((MappingMetaData)objectObjectCursor.value).source().uncompressed()), true).v2());
            }
            builder.endArray();
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.customData) {
                builder.field((String)objectObjectCursor.key);
                builder.map((Map)objectObjectCursor.value);
            }
            builder.startObject(IndexMetaData.KEY_ALIASES);
            for (ObjectCursor objectCursor : indexMetaData.getAliases().values()) {
                AliasMetaData.Builder.toXContent((AliasMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            builder.startArray(IndexMetaData.KEY_PRIMARY_TERMS);
            for (int i = 0; i < indexMetaData.getNumberOfShards(); ++i) {
                builder.value(indexMetaData.primaryTerm(i));
            }
            builder.endArray();
            builder.startObject(IndexMetaData.KEY_IN_SYNC_ALLOCATIONS);
            for (IntObjectCursor intObjectCursor : indexMetaData.inSyncAllocationIds) {
                builder.startArray(String.valueOf(intObjectCursor.key));
                for (String allocationId : (Set)intObjectCursor.value) {
                    builder.value(allocationId);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.startObject(IndexMetaData.KEY_ROLLOVER_INFOS);
            for (ObjectCursor objectCursor : indexMetaData.getRolloverInfos().values()) {
                ((RolloverInfo)objectCursor.value).toXContent(builder, params);
            }
            builder.endObject();
            builder.endObject();
        }

        public static IndexMetaData fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new IllegalArgumentException("expected field name but got a " + (Object)((Object)parser.currentToken()));
            }
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("expected object but got a " + (Object)((Object)token));
            }
            boolean mappingVersion = false;
            boolean settingsVersion = false;
            boolean aliasesVersion = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (IndexMetaData.KEY_SETTINGS.equals(currentFieldName)) {
                        builder.settings(Settings.fromXContent(parser));
                        continue;
                    }
                    if (IndexMetaData.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                String mappingType = currentFieldName;
                                Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                                builder.putMapping(new MappingMetaData(mappingType, mappingSource));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + (Object)((Object)token));
                        }
                        continue;
                    }
                    if (IndexMetaData.KEY_ALIASES.equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    if (IndexMetaData.KEY_IN_SYNC_ALLOCATIONS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                String shardId = currentFieldName;
                                HashSet<String> allocationIds = new HashSet<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    allocationIds.add(parser.text());
                                }
                                builder.putInSyncAllocationIds(Integer.valueOf(shardId), allocationIds);
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + (Object)((Object)token));
                        }
                        continue;
                    }
                    if (IndexMetaData.KEY_ROLLOVER_INFOS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                builder.putRolloverInfo(RolloverInfo.parse(parser, currentFieldName));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + (Object)((Object)token));
                        }
                        continue;
                    }
                    if ("warmers".equals(currentFieldName)) {
                        assert (Version.CURRENT.major <= 5);
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(currentFieldName, parser.mapStrings());
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (IndexMetaData.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                                builder.putMapping(new MappingMetaData(new CompressedXContent(parser.binaryValue())));
                                continue;
                            }
                            Map<String, Object> mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = mapping.keySet().iterator().next();
                            builder.putMapping(new MappingMetaData(mappingType, mapping));
                        }
                        continue;
                    }
                    if (IndexMetaData.KEY_PRIMARY_TERMS.equals(currentFieldName)) {
                        LongArrayList list = new LongArrayList();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                list.add(parser.longValue());
                                continue;
                            }
                            throw new IllegalStateException("found a non-numeric value under [primary_terms]");
                        }
                        builder.primaryTerms(list.toArray());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field for an array " + currentFieldName);
                }
                if (token.isValue()) {
                    if (IndexMetaData.KEY_STATE.equals(currentFieldName)) {
                        builder.state(State.fromString(parser.text()));
                        continue;
                    }
                    if (IndexMetaData.KEY_VERSION.equals(currentFieldName)) {
                        builder.version(parser.longValue());
                        continue;
                    }
                    if (IndexMetaData.KEY_MAPPING_VERSION.equals(currentFieldName)) {
                        mappingVersion = true;
                        builder.mappingVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetaData.KEY_SETTINGS_VERSION.equals(currentFieldName)) {
                        settingsVersion = true;
                        builder.settingsVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetaData.KEY_ALIASES_VERSION.equals(currentFieldName)) {
                        aliasesVersion = true;
                        builder.aliasesVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetaData.KEY_ROUTING_NUM_SHARDS.equals(currentFieldName)) {
                        builder.setRoutingNumShards(parser.intValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + (Object)((Object)token));
            }
            if (Assertions.ENABLED && Version.indexCreated(builder.settings).onOrAfter(Version.V_6_5_0)) assert (mappingVersion) : "mapping version should be present for indices created on or after 6.5.0";
            if (Assertions.ENABLED && Version.indexCreated(builder.settings).onOrAfter(Version.V_6_5_0)) assert (settingsVersion) : "settings version should be present for indices created on or after 6.5.0";
            if (Assertions.ENABLED && Version.indexCreated(builder.settings).onOrAfter(Version.V_7_2_0)) assert (aliasesVersion) : "aliases version should be present for indices created on or after 7.2.0";
            return builder.build();
        }
    }

    private static class IndexMetaDataDiff
    implements Diff<IndexMetaData> {
        private final String index;
        private final int routingNumShards;
        private final long version;
        private final long mappingVersion;
        private final long settingsVersion;
        private final long aliasesVersion;
        private final long[] primaryTerms;
        private final State state;
        private final Settings settings;
        private final Diff<ImmutableOpenMap<String, MappingMetaData>> mappings;
        private final Diff<ImmutableOpenMap<String, AliasMetaData>> aliases;
        private final Diff<ImmutableOpenMap<String, DiffableStringMap>> customData;
        private final Diff<ImmutableOpenIntMap<Set<String>>> inSyncAllocationIds;
        private final Diff<ImmutableOpenMap<String, RolloverInfo>> rolloverInfos;

        IndexMetaDataDiff(IndexMetaData before, IndexMetaData after) {
            this.index = after.index.getName();
            this.version = after.version;
            this.mappingVersion = after.mappingVersion;
            this.settingsVersion = after.settingsVersion;
            this.aliasesVersion = after.aliasesVersion;
            this.routingNumShards = after.routingNumShards;
            this.state = after.state;
            this.settings = after.settings;
            this.primaryTerms = after.primaryTerms;
            this.mappings = DiffableUtils.diff(before.mappings, after.mappings, DiffableUtils.getStringKeySerializer());
            this.aliases = DiffableUtils.diff(before.aliases, after.aliases, DiffableUtils.getStringKeySerializer());
            this.customData = DiffableUtils.diff(before.customData, after.customData, DiffableUtils.getStringKeySerializer());
            this.inSyncAllocationIds = DiffableUtils.diff(before.inSyncAllocationIds, after.inSyncAllocationIds, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
            this.rolloverInfos = DiffableUtils.diff(before.rolloverInfos, after.rolloverInfos, DiffableUtils.getStringKeySerializer());
        }

        IndexMetaDataDiff(StreamInput in) throws IOException {
            this.index = in.readString();
            this.routingNumShards = in.readInt();
            this.version = in.readLong();
            this.mappingVersion = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readVLong() : 1L;
            this.settingsVersion = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readVLong() : 1L;
            this.aliasesVersion = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readVLong() : 1L;
            this.state = State.fromId(in.readByte());
            this.settings = Settings.readSettingsFromStream(in);
            this.primaryTerms = in.readVLongArray();
            this.mappings = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), MappingMetaData::new, MappingMetaData::readDiffFrom);
            this.aliases = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), AliasMetaData::new, AliasMetaData::readDiffFrom);
            this.customData = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), DiffableStringMap::new, DiffableStringMap::readDiffFrom);
            this.inSyncAllocationIds = DiffableUtils.readImmutableOpenIntMapDiff(in, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
            if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
                this.rolloverInfos = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), RolloverInfo::new, RolloverInfo::readDiffFrom);
            } else {
                ImmutableOpenMap emptyMap = ImmutableOpenMap.of();
                this.rolloverInfos = DiffableUtils.diff(emptyMap, emptyMap, DiffableUtils.getStringKeySerializer());
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeInt(this.routingNumShards);
            out.writeLong(this.version);
            if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
                out.writeVLong(this.mappingVersion);
            }
            if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
                out.writeVLong(this.settingsVersion);
            }
            if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
                out.writeVLong(this.aliasesVersion);
            }
            out.writeByte(this.state.id);
            Settings.writeSettingsToStream(this.settings, out);
            out.writeVLongArray(this.primaryTerms);
            this.mappings.writeTo(out);
            this.aliases.writeTo(out);
            this.customData.writeTo(out);
            this.inSyncAllocationIds.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                this.rolloverInfos.writeTo(out);
            }
        }

        @Override
        public IndexMetaData apply(IndexMetaData part) {
            Builder builder = IndexMetaData.builder(this.index);
            builder.version(this.version);
            builder.mappingVersion(this.mappingVersion);
            builder.settingsVersion(this.settingsVersion);
            builder.aliasesVersion(this.aliasesVersion);
            builder.setRoutingNumShards(this.routingNumShards);
            builder.state(this.state);
            builder.settings(this.settings);
            builder.primaryTerms(this.primaryTerms);
            builder.mappings.putAll((Iterable)this.mappings.apply(part.mappings));
            builder.aliases.putAll((Iterable)this.aliases.apply(part.aliases));
            builder.customMetaData.putAll((Iterable)this.customData.apply(part.customData));
            builder.inSyncAllocationIds.putAll((Iterable)this.inSyncAllocationIds.apply(part.inSyncAllocationIds));
            builder.rolloverInfos.putAll((Iterable)this.rolloverInfos.apply(part.rolloverInfos));
            return builder.build();
        }
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for [" + state + "]");
        }
    }
}

