/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.AbstractDiffable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.Diff;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlock;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.set.Sets;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public class ClusterBlocks
extends AbstractDiffable<ClusterBlocks> {
    public static final ClusterBlocks EMPTY_CLUSTER_BLOCK = new ClusterBlocks(Collections.emptySet(), ImmutableOpenMap.of());
    private final Set<ClusterBlock> global;
    private final ImmutableOpenMap<String, Set<ClusterBlock>> indicesBlocks;
    private final EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders;

    ClusterBlocks(Set<ClusterBlock> global, ImmutableOpenMap<String, Set<ClusterBlock>> indicesBlocks) {
        this.global = global;
        this.indicesBlocks = indicesBlocks;
        this.levelHolders = ClusterBlocks.generateLevelHolders(global, indicesBlocks);
    }

    public Set<ClusterBlock> global() {
        return this.global;
    }

    public ImmutableOpenMap<String, Set<ClusterBlock>> indices() {
        return this.indicesBlocks;
    }

    public Set<ClusterBlock> global(ClusterBlockLevel level) {
        return this.levelHolders.get((Object)level).global();
    }

    public ImmutableOpenMap<String, Set<ClusterBlock>> indices(ClusterBlockLevel level) {
        return this.levelHolders.get((Object)level).indices();
    }

    private Set<ClusterBlock> blocksForIndex(ClusterBlockLevel level, String index) {
        return this.indices(level).getOrDefault(index, Collections.emptySet());
    }

    private static EnumMap<ClusterBlockLevel, ImmutableLevelHolder> generateLevelHolders(Set<ClusterBlock> global, ImmutableOpenMap<String, Set<ClusterBlock>> indicesBlocks) {
        EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders = new EnumMap<ClusterBlockLevel, ImmutableLevelHolder>(ClusterBlockLevel.class);
        for (ClusterBlockLevel level : ClusterBlockLevel.values()) {
            Predicate<ClusterBlock> containsLevel = block -> block.contains(level);
            Set<ClusterBlock> newGlobal = Collections.unmodifiableSet(global.stream().filter(containsLevel).collect(Collectors.toSet()));
            ImmutableOpenMap.Builder indicesBuilder = ImmutableOpenMap.builder();
            for (ObjectObjectCursor<String, Set<ClusterBlock>> objectObjectCursor : indicesBlocks) {
                indicesBuilder.put((String)objectObjectCursor.key, Collections.unmodifiableSet(((Set)objectObjectCursor.value).stream().filter(containsLevel).collect(Collectors.toSet())));
            }
            levelHolders.put(level, new ImmutableLevelHolder(newGlobal, indicesBuilder.build()));
        }
        return levelHolders;
    }

    public boolean disableStatePersistence() {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.disableStatePersistence()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlock(ClusterBlock block) {
        return this.global.contains(block);
    }

    public boolean hasGlobalBlockWithId(int blockId) {
        for (ClusterBlock clusterBlock : this.global) {
            if (clusterBlock.id() != blockId) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlockWithLevel(ClusterBlockLevel level) {
        return this.global(level).size() > 0;
    }

    public boolean hasGlobalBlockWithStatus(RestStatus status) {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.status().equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndexBlock(String index, ClusterBlock block) {
        return this.indicesBlocks.containsKey(index) && this.indicesBlocks.get(index).contains(block);
    }

    public boolean hasIndexBlockWithId(String index, int blockId) {
        Set<ClusterBlock> clusterBlocks = this.indicesBlocks.get(index);
        if (clusterBlocks != null) {
            for (ClusterBlock clusterBlock : clusterBlocks) {
                if (clusterBlock.id() != blockId) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ClusterBlock getIndexBlockWithId(String index, int blockId) {
        Set<ClusterBlock> clusterBlocks = this.indicesBlocks.get(index);
        if (clusterBlocks != null) {
            for (ClusterBlock clusterBlock : clusterBlocks) {
                if (clusterBlock.id() != blockId) continue;
                return clusterBlock;
            }
        }
        return null;
    }

    public void globalBlockedRaiseException(ClusterBlockLevel level) throws ClusterBlockException {
        ClusterBlockException blockException = this.globalBlockedException(level);
        if (blockException != null) {
            throw blockException;
        }
    }

    private boolean globalBlocked(ClusterBlockLevel level) {
        return !this.global(level).isEmpty();
    }

    public ClusterBlockException globalBlockedException(ClusterBlockLevel level) {
        if (!this.globalBlocked(level)) {
            return null;
        }
        return new ClusterBlockException(this.global(level));
    }

    public void indexBlockedRaiseException(ClusterBlockLevel level, String index) throws ClusterBlockException {
        ClusterBlockException blockException = this.indexBlockedException(level, index);
        if (blockException != null) {
            throw blockException;
        }
    }

    public ClusterBlockException indexBlockedException(ClusterBlockLevel level, String index) {
        return this.indicesBlockedException(level, new String[]{index});
    }

    public boolean indexBlocked(ClusterBlockLevel level, String index) {
        return this.globalBlocked(level) || !this.blocksForIndex(level, index).isEmpty();
    }

    public ClusterBlockException indicesBlockedException(ClusterBlockLevel level, String[] indices) {
        Set<ClusterBlock> globalLevelBlocks = this.global(level);
        HashMap<String, Set<ClusterBlock>> indexLevelBlocks = new HashMap<String, Set<ClusterBlock>>();
        for (String index : indices) {
            Set<ClusterBlock> indexBlocks = this.blocksForIndex(level, index);
            if (indexBlocks.isEmpty() && globalLevelBlocks.isEmpty()) continue;
            indexLevelBlocks.put(index, Sets.union(indexBlocks, globalLevelBlocks));
        }
        if (indexLevelBlocks.isEmpty()) {
            if (!globalLevelBlocks.isEmpty()) {
                return new ClusterBlockException(globalLevelBlocks);
            }
            return null;
        }
        return new ClusterBlockException(indexLevelBlocks);
    }

    public ClusterBlockException indicesAllowReleaseResources(String[] indices) {
        Set<ClusterBlock> globalBlocks = this.global(ClusterBlockLevel.METADATA_WRITE).stream().filter(clusterBlock -> !clusterBlock.isAllowReleaseResources()).collect(Collectors.toSet());
        HashMap<String, Set<ClusterBlock>> indexLevelBlocks = new HashMap<String, Set<ClusterBlock>>();
        for (String index : indices) {
            Set blocks = Sets.union(globalBlocks, this.blocksForIndex(ClusterBlockLevel.METADATA_WRITE, index)).stream().filter(clusterBlock -> !clusterBlock.isAllowReleaseResources()).collect(Collectors.toSet());
            if (blocks.isEmpty()) continue;
            indexLevelBlocks.put(index, Sets.union(globalBlocks, blocks));
        }
        if (indexLevelBlocks.isEmpty()) {
            if (!globalBlocks.isEmpty()) {
                return new ClusterBlockException(globalBlocks);
            }
            return null;
        }
        return new ClusterBlockException(indexLevelBlocks);
    }

    public String toString() {
        if (this.global.isEmpty() && this.indices().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("blocks: \n");
        if (!this.global.isEmpty()) {
            sb.append("   _global_:\n");
            for (ClusterBlock clusterBlock : this.global) {
                sb.append("      ").append(clusterBlock);
            }
        }
        for (ObjectObjectCursor objectObjectCursor : this.indices()) {
            sb.append("   ").append((String)objectObjectCursor.key).append(":\n");
            for (ClusterBlock block : (Set)objectObjectCursor.value) {
                sb.append("      ").append(block);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ClusterBlocks.writeBlockSet(this.global, out);
        out.writeVInt(this.indicesBlocks.size());
        for (ObjectObjectCursor<String, Set<ClusterBlock>> objectObjectCursor : this.indicesBlocks) {
            out.writeString((String)objectObjectCursor.key);
            ClusterBlocks.writeBlockSet((Set)objectObjectCursor.value, out);
        }
    }

    private static void writeBlockSet(Set<ClusterBlock> blocks, StreamOutput out) throws IOException {
        out.writeVInt(blocks.size());
        for (ClusterBlock block : blocks) {
            block.writeTo(out);
        }
    }

    public ClusterBlocks(StreamInput in) throws IOException {
        Set<ClusterBlock> global = ClusterBlocks.readBlockSet(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder<String, Set<ClusterBlock>> indicesBuilder = ImmutableOpenMap.builder(size);
        for (int j = 0; j < size; ++j) {
            indicesBuilder.put(in.readString().intern(), ClusterBlocks.readBlockSet(in));
        }
        this.global = global;
        this.indicesBlocks = indicesBuilder.build();
        this.levelHolders = ClusterBlocks.generateLevelHolders(global, this.indicesBlocks);
    }

    private static Set<ClusterBlock> readBlockSet(StreamInput in) throws IOException {
        int totalBlocks = in.readVInt();
        HashSet<ClusterBlock> blocks = new HashSet<ClusterBlock>(totalBlocks);
        for (int i = 0; i < totalBlocks; ++i) {
            blocks.add(new ClusterBlock(in));
        }
        return Collections.unmodifiableSet(blocks);
    }

    public static Diff<ClusterBlocks> readDiffFrom(StreamInput in) throws IOException {
        return AbstractDiffable.readDiffFrom(ClusterBlocks::new, in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<ClusterBlock> global = new HashSet<ClusterBlock>();
        private Map<String, Set<ClusterBlock>> indices = new HashMap<String, Set<ClusterBlock>>();

        public Builder blocks(ClusterBlocks blocks) {
            this.global.addAll(blocks.global());
            for (ObjectObjectCursor<String, Set<ClusterBlock>> objectObjectCursor : blocks.indices()) {
                if (!this.indices.containsKey(objectObjectCursor.key)) {
                    this.indices.put((String)objectObjectCursor.key, new HashSet());
                }
                this.indices.get(objectObjectCursor.key).addAll((Collection)objectObjectCursor.value);
            }
            return this;
        }

        public Builder addBlocks(IndexMetaData indexMetaData) {
            String indexName = indexMetaData.getIndex().getName();
            if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                this.addIndexBlock(indexName, MetaDataIndexStateService.INDEX_CLOSED_BLOCK);
            }
            if (IndexMetaData.INDEX_READ_ONLY_SETTING.get(indexMetaData.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetaData.INDEX_READ_ONLY_BLOCK);
            }
            if (IndexMetaData.INDEX_BLOCKS_READ_SETTING.get(indexMetaData.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetaData.INDEX_READ_BLOCK);
            }
            if (IndexMetaData.INDEX_BLOCKS_WRITE_SETTING.get(indexMetaData.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetaData.INDEX_WRITE_BLOCK);
            }
            if (IndexMetaData.INDEX_BLOCKS_METADATA_SETTING.get(indexMetaData.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetaData.INDEX_METADATA_BLOCK);
            }
            if (IndexMetaData.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.get(indexMetaData.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetaData.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);
            }
            return this;
        }

        public Builder updateBlocks(IndexMetaData indexMetaData) {
            this.indices.remove(indexMetaData.getIndex().getName());
            return this.addBlocks(indexMetaData);
        }

        public Builder addGlobalBlock(ClusterBlock block) {
            this.global.add(block);
            return this;
        }

        public Builder removeGlobalBlock(ClusterBlock block) {
            this.global.remove(block);
            return this;
        }

        public Builder removeGlobalBlock(int blockId) {
            this.global.removeIf(block -> block.id() == blockId);
            return this;
        }

        public Builder addIndexBlock(String index, ClusterBlock block) {
            if (!this.indices.containsKey(index)) {
                this.indices.put(index, new HashSet());
            }
            this.indices.get(index).add(block);
            return this;
        }

        public Builder removeIndexBlocks(String index) {
            if (!this.indices.containsKey(index)) {
                return this;
            }
            this.indices.remove(index);
            return this;
        }

        public Builder removeIndexBlock(String index, ClusterBlock block) {
            if (!this.indices.containsKey(index)) {
                return this;
            }
            this.indices.get(index).remove(block);
            if (this.indices.get(index).isEmpty()) {
                this.indices.remove(index);
            }
            return this;
        }

        public Builder removeIndexBlockWithId(String index, int blockId) {
            Set<ClusterBlock> indexBlocks = this.indices.get(index);
            if (indexBlocks == null) {
                return this;
            }
            indexBlocks.removeIf(block -> block.id() == blockId);
            if (indexBlocks.isEmpty()) {
                this.indices.remove(index);
            }
            return this;
        }

        public ClusterBlocks build() {
            ImmutableOpenMap.Builder indicesBuilder = ImmutableOpenMap.builder(this.indices.size());
            for (Map.Entry<String, Set<ClusterBlock>> entry : this.indices.entrySet()) {
                indicesBuilder.put(entry.getKey(), Collections.unmodifiableSet(new HashSet(entry.getValue())));
            }
            return new ClusterBlocks(Collections.unmodifiableSet(new HashSet<ClusterBlock>(this.global)), indicesBuilder.build());
        }
    }

    static class ImmutableLevelHolder {
        private final Set<ClusterBlock> global;
        private final ImmutableOpenMap<String, Set<ClusterBlock>> indices;

        ImmutableLevelHolder(Set<ClusterBlock> global, ImmutableOpenMap<String, Set<ClusterBlock>> indices) {
            this.global = global;
            this.indices = indices;
        }

        public Set<ClusterBlock> global() {
            return this.global;
        }

        public ImmutableOpenMap<String, Set<ClusterBlock>> indices() {
            return this.indices;
        }
    }
}

