/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.watcher;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;

public final class PutWatchRequest
implements Validatable {
    private static final Pattern NO_WS_PATTERN = Pattern.compile("\\S+");
    private final String id;
    private final BytesReference source;
    private final XContentType xContentType;
    private boolean active = true;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public PutWatchRequest(String id, BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(id, "watch id is missing");
        if (!PutWatchRequest.isValidId(id)) {
            throw new IllegalArgumentException("watch id contains whitespace");
        }
        Objects.requireNonNull(source, "watch source is missing");
        Objects.requireNonNull(xContentType, "request body is missing");
        this.id = id;
        this.source = source;
        this.xContentType = xContentType;
    }

    public String getId() {
        return this.id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public PutWatchRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    public PutWatchRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    public static boolean isValidId(String id) {
        return !Strings.isEmpty(id) && NO_WS_PATTERN.matcher(id).matches();
    }
}

