/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.QueryConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;

public class SourceConfig
implements ToXContentObject {
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ConstructingObjectParser<SourceConfig, Void> PARSER = new ConstructingObjectParser("transform_config_source", true, args -> {
        String[] index = ((List)args[0]).toArray(new String[0]);
        QueryConfig queryConfig = (QueryConfig)args[1];
        return new SourceConfig(index, queryConfig);
    });
    private final String[] index;
    private final QueryConfig queryConfig;

    public SourceConfig(String ... index) {
        this.index = index;
        this.queryConfig = null;
    }

    SourceConfig(String[] index, QueryConfig queryConfig) {
        this.index = index;
        this.queryConfig = queryConfig;
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.index != null) {
            builder.array(INDEX.getPreferredName(), this.index);
        }
        if (this.queryConfig != null) {
            builder.field(QUERY.getPreferredName(), this.queryConfig);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SourceConfig that = (SourceConfig)other;
        return Arrays.equals(this.index, that.index) && Objects.equals(this.queryConfig, that.queryConfig);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(this.index);
        return 31 * hash + (this.queryConfig == null ? 0 : this.queryConfig.hashCode());
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryConfig.fromXContent(p), QUERY);
    }

    public static class Builder {
        private String[] index;
        private QueryConfig queryConfig;

        public Builder setIndex(String ... index) {
            this.index = index;
            return this;
        }

        public Builder setQueryConfig(QueryConfig queryConfig) {
            this.queryConfig = queryConfig;
            return this;
        }

        public Builder setQuery(QueryBuilder query) {
            return this.setQueryConfig(new QueryConfig(query));
        }

        public SourceConfig build() {
            return new SourceConfig(this.index, this.queryConfig);
        }
    }
}

