/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public final class PutPrivilegesResponse {
    private final Map<String, Map<String, Boolean>> applicationPrivilegesCreatedOrUpdated;

    public PutPrivilegesResponse(Map<String, Map<String, Boolean>> applicationPrivilegesCreatedOrUpdated) {
        this.applicationPrivilegesCreatedOrUpdated = Collections.unmodifiableMap(applicationPrivilegesCreatedOrUpdated);
    }

    public boolean wasCreated(String applicationName, String privilegeName) {
        if (!Strings.hasText(applicationName)) {
            throw new IllegalArgumentException("application name is required");
        }
        if (!Strings.hasText(privilegeName)) {
            throw new IllegalArgumentException("privilege name is required");
        }
        if (this.applicationPrivilegesCreatedOrUpdated.get(applicationName) == null || this.applicationPrivilegesCreatedOrUpdated.get(applicationName).get(privilegeName) == null) {
            throw new IllegalArgumentException("application name or privilege name not found in the response");
        }
        return this.applicationPrivilegesCreatedOrUpdated.get(applicationName).get(privilegeName);
    }

    public static PutPrivilegesResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Map<String, Boolean>> applicationPrivilegesCreatedOrUpdated = new HashMap<String, Map<String, Boolean>>();
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        Map<String, Object> appNameToPrivStatus = parser.map();
        for (Map.Entry<String, Object> entry : appNameToPrivStatus.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map privilegeToStatus = applicationPrivilegesCreatedOrUpdated.computeIfAbsent(entry.getKey(), a -> new HashMap());
                Map createdOrUpdated = (Map)entry.getValue();
                for (String privilegeName : createdOrUpdated.keySet()) {
                    if (createdOrUpdated.get(privilegeName) instanceof Map) {
                        Map statusMap = (Map)createdOrUpdated.get(privilegeName);
                        Object status = statusMap.get("created");
                        if (status instanceof Boolean) {
                            privilegeToStatus.put(privilegeName, (Boolean)status);
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Failed to parse object, unexpected structure", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Failed to parse object, unexpected structure", new Object[0]);
                }
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Failed to parse object, unexpected structure", new Object[0]);
        }
        return new PutPrivilegesResponse(applicationPrivilegesCreatedOrUpdated);
    }
}

