/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.Operator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class RuleCondition
implements ToXContentObject {
    public static final ParseField RULE_CONDITION_FIELD = new ParseField("rule_condition", new String[0]);
    public static final ParseField APPLIES_TO_FIELD = new ParseField("applies_to", new String[0]);
    public static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<RuleCondition, Void> PARSER = new ConstructingObjectParser(RULE_CONDITION_FIELD.getPreferredName(), true, a -> new RuleCondition((AppliesTo)((Object)((Object)a[0])), (Operator)((Object)((Object)a[1])), (Double)a[2]));
    private final AppliesTo appliesTo;
    private final Operator operator;
    private final double value;

    public RuleCondition(AppliesTo appliesTo, Operator operator, double value) {
        this.appliesTo = appliesTo;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(APPLIES_TO_FIELD.getPreferredName(), (Object)this.appliesTo);
        builder.field(Operator.OPERATOR_FIELD.getPreferredName(), (Object)this.operator);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition)obj;
        return this.appliesTo == other.appliesTo && this.operator == other.operator && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appliesTo, this.operator, this.value});
    }

    public static RuleCondition createTime(Operator operator, long epochSeconds) {
        return new RuleCondition(AppliesTo.TIME, operator, epochSeconds);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return AppliesTo.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, APPLIES_TO_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Operator.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, Operator.OPERATOR_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), VALUE_FIELD);
    }

    public static enum AppliesTo {
        ACTUAL,
        TYPICAL,
        DIFF_FROM_TYPICAL,
        TIME;


        public static AppliesTo fromString(String value) {
            return AppliesTo.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

