/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference.trainedmodel.ensemble.OutputAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class WeightedMode
implements OutputAggregator {
    public static final String NAME = "weighted_mode";
    public static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    private static final ConstructingObjectParser<WeightedMode, Void> PARSER = new ConstructingObjectParser("weighted_mode", true, a -> new WeightedMode((List)a[0]));
    private final List<Double> weights;

    public static WeightedMode fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public WeightedMode(List<Double> weights) {
        this.weights = weights;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weights != null) {
            builder.field(WEIGHTS.getPreferredName(), this.weights);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedMode that = (WeightedMode)o;
        return Objects.equals(this.weights, that.weights);
    }

    public int hashCode() {
        return Objects.hash(this.weights);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), WEIGHTS);
    }
}

