/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.common.TimeUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference.TrainedModelDefinition;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class TrainedModelConfig
implements ToXContentObject {
    public static final String NAME = "trained_model_doc";
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField CREATED_BY = new ParseField("created_by", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField CREATED_TIME = new ParseField("created_time", new String[0]);
    public static final ParseField MODEL_VERSION = new ParseField("model_version", new String[0]);
    public static final ParseField DEFINITION = new ParseField("definition", new String[0]);
    public static final ParseField MODEL_TYPE = new ParseField("model_type", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("trained_model_doc", true, Builder::new);
    private final String modelId;
    private final String createdBy;
    private final Version version;
    private final String description;
    private final Instant createdTime;
    private final Long modelVersion;
    private final String modelType;
    private final Map<String, Object> metadata;
    private final TrainedModelDefinition definition;

    public static Builder fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    TrainedModelConfig(String modelId, String createdBy, Version version, String description, Instant createdTime, Long modelVersion, String modelType, TrainedModelDefinition definition, Map<String, Object> metadata) {
        this.modelId = modelId;
        this.createdBy = createdBy;
        this.version = version;
        this.createdTime = Instant.ofEpochMilli(createdTime.toEpochMilli());
        this.modelType = modelType;
        this.definition = definition;
        this.description = description;
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        this.modelVersion = modelVersion;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public Long getModelVersion() {
        return this.modelVersion;
    }

    public String getModelType() {
        return this.modelType;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public TrainedModelDefinition getDefinition() {
        return this.definition;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelId != null) {
            builder.field(MODEL_ID.getPreferredName(), this.modelId);
        }
        if (this.createdBy != null) {
            builder.field(CREATED_BY.getPreferredName(), this.createdBy);
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version.toString());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.createdTime != null) {
            builder.timeField(CREATED_TIME.getPreferredName(), CREATED_TIME.getPreferredName() + "_string", this.createdTime.toEpochMilli());
        }
        if (this.modelVersion != null) {
            builder.field(MODEL_VERSION.getPreferredName(), this.modelVersion);
        }
        if (this.modelType != null) {
            builder.field(MODEL_TYPE.getPreferredName(), this.modelType);
        }
        if (this.definition != null) {
            builder.field(DEFINITION.getPreferredName(), this.definition);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelConfig that = (TrainedModelConfig)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.modelVersion, that.modelVersion) && Objects.equals(this.modelType, that.modelType) && Objects.equals(this.definition, that.definition) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.createdBy, this.version, this.createdTime, this.modelType, this.definition, this.description, this.metadata, this.modelVersion);
    }

    static {
        PARSER.declareString(Builder::setModelId, MODEL_ID);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setCreatedBy(x$0), CREATED_BY);
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setVersion(x$0), VERSION);
        PARSER.declareString(Builder::setDescription, DESCRIPTION);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setCreatedTime(x$0), (p, c) -> TimeUtil.parseTimeFieldToInstant(p, CREATED_TIME.getPreferredName()), CREATED_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(Builder::setModelVersion, MODEL_VERSION);
        PARSER.declareString(Builder::setModelType, MODEL_TYPE);
        PARSER.declareObject(Builder::setMetadata, (p, c) -> p.map(), METADATA);
        PARSER.declareObject(Builder::setDefinition, (p, c) -> TrainedModelDefinition.fromXContent(p), DEFINITION);
    }

    public static class Builder {
        private String modelId;
        private String createdBy;
        private Version version;
        private String description;
        private Instant createdTime;
        private Long modelVersion;
        private String modelType;
        private Map<String, Object> metadata;
        private TrainedModelDefinition.Builder definition;

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        private Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        private Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        private Builder setVersion(String version) {
            return this.setVersion(Version.fromString(version));
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        private Builder setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public Builder setModelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setDefinition(TrainedModelDefinition.Builder definition) {
            this.definition = definition;
            return this;
        }

        public TrainedModelConfig build() {
            return new TrainedModelConfig(this.modelId, this.createdBy, this.version, this.description, this.createdTime, this.modelVersion, this.modelType, this.definition == null ? null : this.definition.build(), this.metadata);
        }
    }
}

