/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.MlFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class UpdateFilterRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField ADD_ITEMS = new ParseField("add_items", new String[0]);
    public static final ParseField REMOVE_ITEMS = new ParseField("remove_items", new String[0]);
    public static final ConstructingObjectParser<UpdateFilterRequest, Void> PARSER = new ConstructingObjectParser("update_filter_request", a -> new UpdateFilterRequest((String)a[0]));
    private String filterId;
    private String description;
    private SortedSet<String> addItems;
    private SortedSet<String> removeItems;

    public UpdateFilterRequest(String filterId) {
        this.filterId = Objects.requireNonNull(filterId, "[" + MlFilter.ID.getPreferredName() + "] must not be null");
    }

    public String getFilterId() {
        return this.filterId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SortedSet<String> getAddItems() {
        return this.addItems;
    }

    public void setAddItems(Collection<String> addItems) {
        this.addItems = new TreeSet<String>(Objects.requireNonNull(addItems, "[" + ADD_ITEMS.getPreferredName() + "] must not be null"));
    }

    public SortedSet<String> getRemoveItems() {
        return this.removeItems;
    }

    public void setRemoveItems(Collection<String> removeItems) {
        this.removeItems = new TreeSet<String>(Objects.requireNonNull(removeItems, "[" + REMOVE_ITEMS.getPreferredName() + "] must not be null"));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MlFilter.ID.getPreferredName(), this.filterId);
        if (this.description != null) {
            builder.field(MlFilter.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.addItems != null) {
            builder.field(ADD_ITEMS.getPreferredName(), this.addItems);
        }
        if (this.removeItems != null) {
            builder.field(REMOVE_ITEMS.getPreferredName(), this.removeItems);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.filterId, this.description, this.addItems, this.removeItems);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateFilterRequest other = (UpdateFilterRequest)obj;
        return Objects.equals(this.filterId, other.filterId) && Objects.equals(this.description, other.description) && Objects.equals(this.addItems, other.addItems) && Objects.equals(this.removeItems, other.removeItems);
    }

    public final String toString() {
        return Strings.toString(this);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MlFilter.ID);
        PARSER.declareStringOrNull(UpdateFilterRequest::setDescription, MlFilter.DESCRIPTION);
        PARSER.declareStringArray(UpdateFilterRequest::setAddItems, ADD_ITEMS);
        PARSER.declareStringArray(UpdateFilterRequest::setRemoveItems, REMOVE_ITEMS);
    }
}

