/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;

public class StopDataFrameAnalyticsRequest
implements Validatable {
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    public static final ParseField FORCE = new ParseField("force", new String[0]);
    private final String id;
    private Boolean allowNoMatch;
    private Boolean force;
    private TimeValue timeout;

    public StopDataFrameAnalyticsRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public StopDataFrameAnalyticsRequest setTimeout(@Nullable TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public StopDataFrameAnalyticsRequest setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
        return this;
    }

    public Boolean getForce() {
        return this.force;
    }

    public StopDataFrameAnalyticsRequest setForce(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            return Optional.of(ValidationException.withError("data frame analytics id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopDataFrameAnalyticsRequest other = (StopDataFrameAnalyticsRequest)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.allowNoMatch, other.allowNoMatch) && Objects.equals(this.force, other.force);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timeout, this.allowNoMatch, this.force);
    }
}

