/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;

public class StartDataFrameAnalyticsRequest
implements Validatable {
    private final String id;
    private TimeValue timeout;

    public StartDataFrameAnalyticsRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public StartDataFrameAnalyticsRequest setTimeout(@Nullable TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            return Optional.of(ValidationException.withError("data frame analytics id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartDataFrameAnalyticsRequest other = (StartDataFrameAnalyticsRequest)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.timeout, other.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timeout);
    }
}

