/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.datafeed.DatafeedConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetDatafeedStatsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField ALLOW_NO_DATAFEEDS = new ParseField("allow_no_datafeeds", new String[0]);
    public static final ConstructingObjectParser<GetDatafeedStatsRequest, Void> PARSER = new ConstructingObjectParser("get_datafeed_stats_request", a -> new GetDatafeedStatsRequest((List)a[0]));
    private static final String ALL_DATAFEEDS = "_all";
    private final List<String> datafeedIds;
    private Boolean allowNoDatafeeds;

    public static GetDatafeedStatsRequest getAllDatafeedStatsRequest() {
        return new GetDatafeedStatsRequest(ALL_DATAFEEDS);
    }

    GetDatafeedStatsRequest(List<String> datafeedIds) {
        if (datafeedIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("datafeedIds must not contain null values");
        }
        this.datafeedIds = new ArrayList<String>(datafeedIds);
    }

    public GetDatafeedStatsRequest(String ... datafeedIds) {
        this(Arrays.asList(datafeedIds));
    }

    public List<String> getDatafeedIds() {
        return this.datafeedIds;
    }

    public Boolean getAllowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    public void setAllowNoDatafeeds(boolean allowNoDatafeeds) {
        this.allowNoDatafeeds = allowNoDatafeeds;
    }

    public int hashCode() {
        return Objects.hash(this.datafeedIds, this.allowNoDatafeeds);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetDatafeedStatsRequest that = (GetDatafeedStatsRequest)other;
        return Objects.equals(this.datafeedIds, that.datafeedIds) && Objects.equals(this.allowNoDatafeeds, that.allowNoDatafeeds);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.datafeedIds));
        if (this.allowNoDatafeeds != null) {
            builder.field(ALLOW_NO_DATAFEEDS.getPreferredName(), this.allowNoDatafeeds);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> Arrays.asList(Strings.commaDelimitedListToStringArray(p.text())), DatafeedConfig.ID, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareBoolean(GetDatafeedStatsRequest::setAllowNoDatafeeds, ALLOW_NO_DATAFEEDS);
    }
}

