/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indexlifecycle.LifecycleAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class ForceMergeAction
implements LifecycleAction,
ToXContentObject {
    public static final String NAME = "forcemerge";
    private static final ParseField MAX_NUM_SEGMENTS_FIELD = new ParseField("max_num_segments", new String[0]);
    private static final ConstructingObjectParser<ForceMergeAction, Void> PARSER = new ConstructingObjectParser("forcemerge", true, a -> {
        int maxNumSegments = (Integer)a[0];
        return new ForceMergeAction(maxNumSegments);
    });
    private final int maxNumSegments;

    public static ForceMergeAction parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public ForceMergeAction(int maxNumSegments) {
        if (maxNumSegments <= 0) {
            throw new IllegalArgumentException("[" + MAX_NUM_SEGMENTS_FIELD.getPreferredName() + "] must be a positive integer");
        }
        this.maxNumSegments = maxNumSegments;
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MAX_NUM_SEGMENTS_FIELD.getPreferredName(), this.maxNumSegments);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.maxNumSegments);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ForceMergeAction other = (ForceMergeAction)obj;
        return Objects.equals(this.maxNumSegments, other.maxNumSegments);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_NUM_SEGMENTS_FIELD);
    }
}

