/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Cancellable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ClusterRequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public final class ClusterClient {
    private final RestHighLevelClient restHighLevelClient;

    ClusterClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public ClusterUpdateSettingsResponse putSettings(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(clusterUpdateSettingsRequest, ClusterRequestConverters::clusterPutSettings, options, ClusterUpdateSettingsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putSettingsAsync(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, RequestOptions options, ActionListener<ClusterUpdateSettingsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(clusterUpdateSettingsRequest, ClusterRequestConverters::clusterPutSettings, options, ClusterUpdateSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClusterGetSettingsResponse getSettings(ClusterGetSettingsRequest clusterGetSettingsRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(clusterGetSettingsRequest, ClusterRequestConverters::clusterGetSettings, options, ClusterGetSettingsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getSettingsAsync(ClusterGetSettingsRequest clusterGetSettingsRequest, RequestOptions options, ActionListener<ClusterGetSettingsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(clusterGetSettingsRequest, ClusterRequestConverters::clusterGetSettings, options, ClusterGetSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClusterHealthResponse health(ClusterHealthRequest healthRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(healthRequest, ClusterRequestConverters::clusterHealth, options, ClusterHealthResponse::fromXContent, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public Cancellable healthAsync(ClusterHealthRequest healthRequest, RequestOptions options, ActionListener<ClusterHealthResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(healthRequest, ClusterRequestConverters::clusterHealth, options, ClusterHealthResponse::fromXContent, listener, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }
}

