/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.IntObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.TransportActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.ReplicationRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.ReplicationResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.CountDown;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastReplicationAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardRequest extends ReplicationRequest<ShardRequest>, ShardResponse extends ReplicationResponse>
extends HandledTransportAction<Request, Response> {
    private final TransportReplicationAction replicatedBroadcastShardAction;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public TransportBroadcastReplicationAction(String name, Writeable.Reader<Request> requestReader, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportReplicationAction replicatedBroadcastShardAction) {
        super(name, transportService, actionFilters, requestReader);
        this.replicatedBroadcastShardAction = replicatedBroadcastShardAction;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected void doExecute(Task task, Request request, final ActionListener<Response> listener) {
        final ClusterState clusterState = this.clusterService.state();
        List<ShardId> shards = this.shards(request, clusterState);
        final CopyOnWriteArrayList shardsResponses = new CopyOnWriteArrayList();
        if (shards.size() == 0) {
            this.finishAndNotifyListener(listener, shardsResponses);
        }
        final CountDown responsesCountDown = new CountDown(shards.size());
        for (final ShardId shardId : shards) {
            ActionListener shardActionListener = new ActionListener<ShardResponse>(){

                @Override
                public void onResponse(ShardResponse shardResponse) {
                    shardsResponses.add(shardResponse);
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got response from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)shardId);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    Object[] failures;
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got failure from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)shardId);
                    int totalNumCopies = clusterState.getMetaData().getIndexSafe(shardId.getIndex()).getNumberOfReplicas() + 1;
                    Object shardResponse = TransportBroadcastReplicationAction.this.newShardResponse();
                    if (TransportActions.isShardNotAvailableException(e)) {
                        failures = new ReplicationResponse.ShardInfo.Failure[]{};
                    } else {
                        ReplicationResponse.ShardInfo.Failure failure = new ReplicationResponse.ShardInfo.Failure(shardId, null, e, ExceptionsHelper.status(e), true);
                        failures = new ReplicationResponse.ShardInfo.Failure[totalNumCopies];
                        Arrays.fill(failures, failure);
                    }
                    ((ReplicationResponse)shardResponse).setShardInfo(new ReplicationResponse.ShardInfo(totalNumCopies, 0, (ReplicationResponse.ShardInfo.Failure[])failures));
                    shardsResponses.add(shardResponse);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }
            };
            this.shardExecute(task, request, shardId, shardActionListener);
        }
    }

    protected void shardExecute(Task task, Request request, ShardId shardId, ActionListener<ShardResponse> shardActionListener) {
        ShardRequest shardRequest = this.newShardRequest(request, shardId);
        shardRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.replicatedBroadcastShardAction.execute(shardRequest, shardActionListener);
    }

    protected List<ShardId> shards(Request request, ClusterState clusterState) {
        String[] concreteIndices;
        ArrayList<ShardId> shardIds = new ArrayList<ShardId>();
        for (String index : concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request)) {
            IndexMetaData indexMetaData = clusterState.metaData().getIndices().get(index);
            if (indexMetaData == null) continue;
            for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : clusterState.getRoutingTable().indicesRouting().get(index).getShards()) {
                shardIds.add(((IndexShardRoutingTable)intObjectCursor.value).shardId());
            }
        }
        return shardIds;
    }

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardRequest newShardRequest(Request var1, ShardId var2);

    private void finishAndNotifyListener(ActionListener listener, CopyOnWriteArrayList<ShardResponse> shardsResponses) {
        this.logger.trace("{}: got all shard responses", (Object)this.actionName);
        int successfulShards = 0;
        int failedShards = 0;
        int totalNumCopies = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.size(); ++i) {
            ReplicationResponse shardResponse = (ReplicationResponse)shardsResponses.get(i);
            if (shardResponse == null) continue;
            failedShards += shardResponse.getShardInfo().getFailed();
            successfulShards += shardResponse.getShardInfo().getSuccessful();
            totalNumCopies += shardResponse.getShardInfo().getTotal();
            if (shardFailures == null) {
                shardFailures = new ArrayList<DefaultShardOperationFailedException>();
            }
            for (ReplicationResponse.ShardInfo.Failure failure : shardResponse.getShardInfo().getFailures()) {
                shardFailures.add(new DefaultShardOperationFailedException(new BroadcastShardOperationFailedException(failure.fullShardId(), failure.getCause())));
            }
        }
        listener.onResponse(this.newResponse(successfulShards, failedShards, totalNumCopies, shardFailures));
    }

    protected abstract BroadcastResponse newResponse(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);
}

