/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopFieldDocs;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TotalHits;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhaseController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.ShardSearchFailure;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.TransportSearchAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHits;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.InternalSearchResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.ProfileShardResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.SearchProfileShardResults;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.Suggest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.completion.CompletionSuggestion;

final class SearchResponseMerger {
    final int from;
    final int size;
    final int trackTotalHitsUpTo;
    private final TransportSearchAction.SearchTimeProvider searchTimeProvider;
    private final Function<Boolean, InternalAggregation.ReduceContext> reduceContextFunction;
    private final List<SearchResponse> searchResponses = new CopyOnWriteArrayList<SearchResponse>();
    private static final Comparator<ShardSearchFailure> FAILURES_COMPARATOR = new Comparator<ShardSearchFailure>(){

        @Override
        public int compare(ShardSearchFailure o1, ShardSearchFailure o2) {
            String clusterAlias2;
            ShardId shardId1 = this.extractShardId(o1);
            ShardId shardId2 = this.extractShardId(o2);
            if (shardId1 == null && shardId2 == null) {
                return 0;
            }
            if (shardId1 == null) {
                return -1;
            }
            if (shardId2 == null) {
                return 1;
            }
            int shardIdCompare = shardId1.compareTo(shardId2);
            if (shardIdCompare != 0) {
                return shardIdCompare;
            }
            String clusterAlias1 = o1.shard() == null ? null : o1.shard().getClusterAlias();
            String string = clusterAlias2 = o2.shard() == null ? null : o2.shard().getClusterAlias();
            if (clusterAlias1 == null && clusterAlias2 == null) {
                return 0;
            }
            if (clusterAlias1 == null) {
                return -1;
            }
            if (clusterAlias2 == null) {
                return 1;
            }
            return clusterAlias1.compareTo(clusterAlias2);
        }

        private ShardId extractShardId(ShardSearchFailure failure) {
            SearchShardTarget shard = failure.shard();
            if (shard != null) {
                return shard.getShardId();
            }
            Throwable cause = failure.getCause();
            if (cause instanceof ElasticsearchException) {
                ElasticsearchException e = (ElasticsearchException)cause;
                return e.getShardId();
            }
            return null;
        }
    };

    SearchResponseMerger(int from, int size, int trackTotalHitsUpTo, TransportSearchAction.SearchTimeProvider searchTimeProvider, Function<Boolean, InternalAggregation.ReduceContext> reduceContextFunction) {
        this.from = from;
        this.size = size;
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        this.searchTimeProvider = Objects.requireNonNull(searchTimeProvider);
        this.reduceContextFunction = Objects.requireNonNull(reduceContextFunction);
    }

    void add(SearchResponse searchResponse) {
        assert (searchResponse.getScrollId() == null) : "merging scroll results is not supported";
        this.searchResponses.add(searchResponse);
    }

    int numResponses() {
        return this.searchResponses.size();
    }

    SearchResponse getMergedResponse(SearchResponse.Clusters clusters) {
        Suggest suggest;
        if (this.searchResponses.size() == 0) {
            return SearchResponse.empty(this.searchTimeProvider::buildTookInMillis, clusters);
        }
        int totalShards = 0;
        int skippedShards = 0;
        int successfulShards = 0;
        int numReducePhases = 1;
        ArrayList failures = new ArrayList();
        HashMap<String, ProfileShardResult> profileResults = new HashMap<String, ProfileShardResult>();
        ArrayList<InternalAggregations> aggs = new ArrayList<InternalAggregations>();
        TreeMap<ShardIdAndClusterAlias, Integer> shards = new TreeMap<ShardIdAndClusterAlias, Integer>();
        ArrayList<TopDocs> topDocsList = new ArrayList<TopDocs>(this.searchResponses.size());
        HashMap<String, List<Suggest.Suggestion>> groupedSuggestions = new HashMap<String, List<Suggest.Suggestion>>();
        Boolean trackTotalHits = null;
        SearchPhaseController.TopDocsStats topDocsStats = new SearchPhaseController.TopDocsStats(this.trackTotalHitsUpTo);
        for (SearchResponse searchResponse : this.searchResponses) {
            TotalHits totalHits;
            SearchHits searchHits;
            totalShards += searchResponse.getTotalShards();
            skippedShards += searchResponse.getSkippedShards();
            successfulShards += searchResponse.getSuccessfulShards();
            numReducePhases += searchResponse.getNumReducePhases();
            Collections.addAll(failures, searchResponse.getShardFailures());
            profileResults.putAll(searchResponse.getProfileResults());
            if (searchResponse.getAggregations() != null) {
                InternalAggregations internalAggs = (InternalAggregations)searchResponse.getAggregations();
                aggs.add(internalAggs);
            }
            if ((suggest = searchResponse.getSuggest()) != null) {
                Object entries2;
                for (Object entries2 : suggest) {
                    List suggestionList = groupedSuggestions.computeIfAbsent(((Suggest.Suggestion)entries2).getName(), s -> new ArrayList());
                    suggestionList.add(entries2);
                }
                List<CompletionSuggestion> completionSuggestions = suggest.filter(CompletionSuggestion.class);
                entries2 = completionSuggestions.iterator();
                while (entries2.hasNext()) {
                    CompletionSuggestion completionSuggestion = (CompletionSuggestion)entries2.next();
                    for (CompletionSuggestion.Entry options : completionSuggestion) {
                        for (CompletionSuggestion.Entry.Option option : options) {
                            SearchShardTarget shard = option.getHit().getShard();
                            ShardIdAndClusterAlias shardId = new ShardIdAndClusterAlias(shard.getShardId(), shard.getClusterAlias());
                            shards.putIfAbsent(shardId, null);
                        }
                    }
                }
            }
            if ((searchHits = searchResponse.getHits()).getTotalHits() == null) {
                totalHits = new TotalHits(0L, TotalHits.Relation.EQUAL_TO);
                assert (trackTotalHits == null || !trackTotalHits.booleanValue());
                trackTotalHits = false;
            } else {
                totalHits = searchHits.getTotalHits();
                assert (trackTotalHits == null || trackTotalHits.booleanValue());
                trackTotalHits = true;
            }
            TopDocs topDocs = SearchResponseMerger.searchHitsToTopDocs(searchHits, totalHits, shards);
            topDocsStats.add(new TopDocsAndMaxScore(topDocs, searchHits.getMaxScore()), searchResponse.isTimedOut(), searchResponse.isTerminatedEarly());
            if (searchHits.getHits().length <= 0) continue;
            topDocsList.add(topDocs);
        }
        SearchResponseMerger.setTopDocsShardIndex(shards, topDocsList);
        TopDocs topDocs = SearchPhaseController.mergeTopDocs(topDocsList, this.size, this.from);
        SearchHits mergedSearchHits = SearchResponseMerger.topDocsToSearchHits(topDocs, topDocsStats);
        SearchResponseMerger.setSuggestShardIndex(shards, groupedSuggestions);
        suggest = groupedSuggestions.isEmpty() ? null : new Suggest(Suggest.reduce(groupedSuggestions));
        InternalAggregations reducedAggs = InternalAggregations.reduce(aggs, this.reduceContextFunction.apply(true));
        ShardSearchFailure[] shardFailures = failures.toArray(ShardSearchFailure.EMPTY_ARRAY);
        SearchProfileShardResults profileShardResults = profileResults.isEmpty() ? null : new SearchProfileShardResults(profileResults);
        Arrays.sort(shardFailures, FAILURES_COMPARATOR);
        InternalSearchResponse response = new InternalSearchResponse(mergedSearchHits, reducedAggs, suggest, profileShardResults, topDocsStats.timedOut, topDocsStats.terminatedEarly, numReducePhases);
        long tookInMillis = this.searchTimeProvider.buildTookInMillis();
        return new SearchResponse(response, null, totalShards, successfulShards, skippedShards, tookInMillis, shardFailures, clusters);
    }

    private static TopDocs searchHitsToTopDocs(SearchHits searchHits, TotalHits totalHits, Map<ShardIdAndClusterAlias, Integer> shards) {
        TopDocs topDocs;
        SearchHit[] hits = searchHits.getHits();
        ScoreDoc[] scoreDocs = new ScoreDoc[hits.length];
        if (searchHits.getSortFields() != null) {
            if (searchHits.getCollapseField() != null) {
                assert (searchHits.getCollapseValues() != null);
                topDocs = new CollapseTopFieldDocs(searchHits.getCollapseField(), totalHits, scoreDocs, searchHits.getSortFields(), searchHits.getCollapseValues());
            } else {
                topDocs = new TopFieldDocs(totalHits, scoreDocs, searchHits.getSortFields());
            }
        } else {
            topDocs = new TopDocs(totalHits, scoreDocs);
        }
        for (int i = 0; i < hits.length; ++i) {
            SearchHit hit = hits[i];
            SearchShardTarget shard = hit.getShard();
            ShardIdAndClusterAlias shardId = new ShardIdAndClusterAlias(shard.getShardId(), shard.getClusterAlias());
            shards.putIfAbsent(shardId, null);
            SortField[] sortFields = searchHits.getSortFields();
            Object[] sortValues = sortFields == null ? null : (sortFields.length == 1 && sortFields[0].getType() == SortField.Type.SCORE ? new Object[]{Float.valueOf(hit.getScore())} : hit.getRawSortValues());
            scoreDocs[i] = new FieldDocAndSearchHit(hit.docId(), hit.getScore(), sortValues, hit);
        }
        return topDocs;
    }

    private static void setTopDocsShardIndex(Map<ShardIdAndClusterAlias, Integer> shards, List<TopDocs> topDocsList) {
        SearchResponseMerger.assignShardIndex(shards);
        for (TopDocs topDocs : topDocsList) {
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                FieldDocAndSearchHit fieldDocAndSearchHit = (FieldDocAndSearchHit)scoreDoc;
                SearchShardTarget shard = fieldDocAndSearchHit.searchHit.getShard();
                ShardIdAndClusterAlias shardId = new ShardIdAndClusterAlias(shard.getShardId(), shard.getClusterAlias());
                assert (shards.containsKey(shardId));
                fieldDocAndSearchHit.shardIndex = shards.get(shardId);
            }
        }
    }

    private static void setSuggestShardIndex(Map<ShardIdAndClusterAlias, Integer> shards, Map<String, List<Suggest.Suggestion>> groupedSuggestions) {
        SearchResponseMerger.assignShardIndex(shards);
        for (List<Suggest.Suggestion> suggestions : groupedSuggestions.values()) {
            for (Suggest.Suggestion suggestion : suggestions) {
                if (!(suggestion instanceof CompletionSuggestion)) continue;
                CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggestion;
                for (CompletionSuggestion.Entry options : completionSuggestion) {
                    for (CompletionSuggestion.Entry.Option option : options) {
                        SearchShardTarget shard = option.getHit().getShard();
                        ShardIdAndClusterAlias shardId = new ShardIdAndClusterAlias(shard.getShardId(), shard.getClusterAlias());
                        assert (shards.containsKey(shardId));
                        option.setShardIndex(shards.get(shardId));
                    }
                }
            }
        }
    }

    private static void assignShardIndex(Map<ShardIdAndClusterAlias, Integer> shards) {
        int shardIndex = 0;
        for (Map.Entry<ShardIdAndClusterAlias, Integer> shard : shards.entrySet()) {
            shard.setValue(shardIndex++);
        }
    }

    private static SearchHits topDocsToSearchHits(TopDocs topDocs, SearchPhaseController.TopDocsStats topDocsStats) {
        SearchHit[] searchHits;
        if (topDocs == null) {
            searchHits = new SearchHit[]{};
        } else {
            searchHits = new SearchHit[topDocs.scoreDocs.length];
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                FieldDocAndSearchHit scoreDoc = (FieldDocAndSearchHit)topDocs.scoreDocs[i];
                searchHits[i] = scoreDoc.searchHit;
            }
        }
        SortField[] sortFields = null;
        String collapseField = null;
        Object[] collapseValues = null;
        if (topDocs instanceof TopFieldDocs) {
            sortFields = ((TopFieldDocs)topDocs).fields;
            if (topDocs instanceof CollapseTopFieldDocs) {
                CollapseTopFieldDocs collapseTopFieldDocs = (CollapseTopFieldDocs)topDocs;
                collapseField = collapseTopFieldDocs.field;
                collapseValues = collapseTopFieldDocs.collapseValues;
            }
        }
        return new SearchHits(searchHits, topDocsStats.getTotalHits(), topDocsStats.getMaxScore(), sortFields, collapseField, collapseValues);
    }

    private static final class ShardIdAndClusterAlias
    implements Comparable<ShardIdAndClusterAlias> {
        private final ShardId shardId;
        private final String clusterAlias;

        ShardIdAndClusterAlias(ShardId shardId, String clusterAlias) {
            this.shardId = shardId;
            assert (clusterAlias != null) : "clusterAlias is null";
            this.clusterAlias = clusterAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardIdAndClusterAlias that = (ShardIdAndClusterAlias)o;
            return this.shardId.equals(that.shardId) && this.clusterAlias.equals(that.clusterAlias);
        }

        public int hashCode() {
            return Objects.hash(this.shardId, this.clusterAlias);
        }

        @Override
        public int compareTo(ShardIdAndClusterAlias o) {
            int shardIdCompareTo = this.shardId.compareTo(o.shardId);
            if (shardIdCompareTo != 0) {
                return shardIdCompareTo;
            }
            return this.clusterAlias.compareTo(o.clusterAlias);
        }
    }

    private static final class FieldDocAndSearchHit
    extends FieldDoc {
        private final SearchHit searchHit;

        FieldDocAndSearchHit(int doc, float score, Object[] fields, SearchHit searchHit) {
            super(doc, score, fields);
            this.searchHit = searchHit;
        }
    }
}

