/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.resync;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.resync.ResyncReplicationRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.resync.ResyncReplicationResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.ReplicationOperation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.ReplicationResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.replication.TransportWriteAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.Translog;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponseHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TransportResyncReplicationAction
extends TransportWriteAction<ResyncReplicationRequest, ResyncReplicationRequest, ResyncReplicationResponse>
implements PrimaryReplicaSyncer.SyncAction {
    private static String ACTION_NAME = "internal:index/seq_no/resync";

    @Inject
    public TransportResyncReplicationAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, ResyncReplicationRequest::new, ResyncReplicationRequest::new, "write", true);
    }

    @Override
    protected ResyncReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ResyncReplicationResponse(in);
    }

    @Override
    protected ReplicationOperation.Replicas newReplicasProxy() {
        return new ResyncActionReplicasProxy();
    }

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected void shardOperationOnPrimary(ResyncReplicationRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> new TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>(TransportResyncReplicationAction.performOnPrimary(request), new ResyncReplicationResponse(), null, null, primary, this.logger));
    }

    public static ResyncReplicationRequest performOnPrimary(ResyncReplicationRequest request) {
        return request;
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult<ResyncReplicationRequest> shardOperationOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = TransportResyncReplicationAction.performOnReplica(request, replica);
        return new TransportWriteAction.WriteReplicaResult<ResyncReplicationRequest>(request, location, null, replica, this.logger);
    }

    public static Translog.Location performOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        replica.updateMaxUnsafeAutoIdTimestamp(request.getMaxSeenAutoIdTimestampOnPrimary());
        for (Translog.Operation operation : request.getOperations()) {
            Engine.Result operationResult = replica.applyTranslogOperation(operation, Engine.Operation.Origin.REPLICA);
            if (operationResult.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + operationResult.getRequiredMappingUpdate());
            }
            location = TransportResyncReplicationAction.syncOperationResultOrThrow(operationResult, location);
        }
        if (request.getTrimAboveSeqNo() != -2L) {
            replica.trimOperationOfPreviousPrimaryTerms(request.getTrimAboveSeqNo());
        }
        return location;
    }

    @Override
    public void sync(ResyncReplicationRequest request, Task parentTask, String primaryAllocationId, long primaryTerm, final ActionListener<ResyncReplicationResponse> listener) {
        this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<ResyncReplicationRequest>(request, primaryAllocationId, primaryTerm), parentTask, this.transportOptions, new TransportResponseHandler<ResyncReplicationResponse>(){

            @Override
            public ResyncReplicationResponse read(StreamInput in) throws IOException {
                return TransportResyncReplicationAction.this.newResponseInstance(in);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public void handleResponse(ResyncReplicationResponse response) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                for (int i = 0; i < failures.length; ++i) {
                    ReplicationResponse.ShardInfo.Failure f = failures[i];
                    TransportResyncReplicationAction.this.logger.info((Message)new ParameterizedMessage("{} primary-replica resync to replica on node [{}] failed", (Object)f.fullShardId(), (Object)f.nodeId()), f.getCause());
                }
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }
        });
    }

    class ResyncActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        ResyncActionReplicasProxy() {
            super(TransportResyncReplicationAction.this);
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            TransportResyncReplicationAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, false, message, exception, listener);
        }
    }
}

