/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.DocsStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportResizeAction
extends TransportMasterNodeAction<ResizeRequest, ResizeResponse> {
    private final MetaDataCreateIndexService createIndexService;
    private final Client client;

    @Inject
    public TransportResizeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        this("indices:admin/resize", transportService, clusterService, threadPool, createIndexService, actionFilters, indexNameExpressionResolver, client);
    }

    protected TransportResizeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, ResizeRequest::new, indexNameExpressionResolver);
        this.createIndexService = createIndexService;
        this.client = client;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ResizeResponse read(StreamInput in) throws IOException {
        return new ResizeResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getTargetIndexRequest().index());
    }

    @Override
    protected void masterOperation(ResizeRequest resizeRequest, ClusterState state, ActionListener<ResizeResponse> listener) {
        String sourceIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getSourceIndex());
        String targetIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getTargetIndexRequest().index());
        this.client.admin().indices().prepareStats(sourceIndex).clear().setDocs(true).execute(ActionListener.delegateFailure(listener, (delegatedListener, indicesStatsResponse) -> {
            CreateIndexClusterStateUpdateRequest updateRequest = TransportResizeAction.prepareCreateIndexRequest(resizeRequest, state, i -> {
                IndexShardStats shard = indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                return shard == null ? null : shard.getPrimary().getDocs();
            }, sourceIndex, targetIndex);
            this.createIndexService.createIndex(updateRequest, ActionListener.map(delegatedListener, response -> new ResizeResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
        }));
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ResizeRequest resizeRequest, ClusterState state, IntFunction<DocsStats> perShardDocStats, String sourceIndexName, String targetIndexName) {
        int numShards;
        CreateIndexRequest targetIndex = resizeRequest.getTargetIndexRequest();
        IndexMetaData metaData = state.metaData().index(sourceIndexName);
        if (metaData == null) {
            throw new IndexNotFoundException(sourceIndexName);
        }
        Settings targetIndexSettings = Settings.builder().put(targetIndex.settings()).normalizePrefix("index.").build();
        if (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            numShards = IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings);
        } else {
            assert (resizeRequest.getResizeType() != ResizeType.SPLIT) : "split must specify the number of shards explicitly";
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                numShards = 1;
            } else {
                assert (resizeRequest.getResizeType() == ResizeType.CLONE);
                numShards = metaData.getNumberOfShards();
            }
        }
        for (int i = 0; i < numShards; ++i) {
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                Set<ShardId> shardIds = IndexMetaData.selectShrinkShards(i, metaData, numShards);
                long count = 0L;
                for (ShardId id : shardIds) {
                    DocsStats docsStats = perShardDocStats.apply(id.id());
                    if (docsStats != null) {
                        count += docsStats.getCount();
                    }
                    if (count <= 0x7FFFFF7FL) continue;
                    throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + shardIds);
                }
                continue;
            }
            if (resizeRequest.getResizeType() == ResizeType.SPLIT) {
                Objects.requireNonNull(IndexMetaData.selectSplitShard(i, metaData, numShards));
                continue;
            }
            Objects.requireNonNull(IndexMetaData.selectCloneShard(i, metaData, numShards));
        }
        if (IndexMetaData.INDEX_ROUTING_PARTITION_SIZE_SETTING.exists(targetIndexSettings)) {
            throw new IllegalArgumentException("cannot provide a routing partition size value when resizing an index");
        }
        if (IndexMetaData.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(targetIndexSettings)) {
            boolean splitFromSingleShards;
            boolean bl = splitFromSingleShards = resizeRequest.getResizeType() == ResizeType.SPLIT && metaData.getNumberOfShards() == 1;
            if (!splitFromSingleShards) {
                throw new IllegalArgumentException("cannot provide index.number_of_routing_shards on resize");
            }
        }
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(metaData.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(targetIndexSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(targetIndexSettings).booleanValue()) {
            throw new IllegalArgumentException("Can't disable [index.soft_deletes.enabled] setting on resize");
        }
        String cause = resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT) + "_index";
        targetIndex.cause(cause);
        Settings.Builder settingsBuilder = Settings.builder().put(targetIndexSettings);
        settingsBuilder.put("index.number_of_shards", numShards);
        targetIndex.settings(settingsBuilder);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, targetIndex.index(), targetIndexName).ackTimeout(targetIndex.timeout())).masterNodeTimeout(targetIndex.masterNodeTimeout())).settings(targetIndex.settings()).aliases(targetIndex.aliases()).waitForActiveShards(targetIndex.waitForActiveShards()).recoverFrom(metaData.getIndex()).resizeType(resizeRequest.getResizeType()).copySettings(resizeRequest.getCopySettings() == null ? false : resizeRequest.getCopySettings());
    }

    @Override
    protected String getMasterActionName(DiscoveryNode node) {
        if (node.getVersion().onOrAfter(ResizeAction.COMPATIBILITY_VERSION)) {
            return super.getMasterActionName(node);
        }
        return "indices:admin/shrink";
    }
}

