/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.rollover.Condition;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActiveShardCount;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActiveShardsObserver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.AliasAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.DocsStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class TransportRolloverAction
extends TransportMasterNodeAction<RolloverRequest, RolloverResponse> {
    private static final Pattern INDEX_NAME_PATTERN = Pattern.compile("^.*-\\d+$");
    private final MetaDataCreateIndexService createIndexService;
    private final MetaDataIndexAliasesService indexAliasesService;
    private final ActiveShardsObserver activeShardsObserver;
    private final Client client;

    @Inject
    public TransportRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetaDataIndexAliasesService indexAliasesService, Client client) {
        super("indices:admin/rollover", transportService, clusterService, threadPool, actionFilters, RolloverRequest::new, indexNameExpressionResolver);
        this.createIndexService = createIndexService;
        this.indexAliasesService = indexAliasesService;
        this.client = client;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected RolloverResponse read(StreamInput in) throws IOException {
        return new RolloverResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(RolloverRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request.indices()));
    }

    @Override
    protected void masterOperation(RolloverRequest request, ClusterState state, ActionListener<RolloverResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void masterOperation(Task task, final RolloverRequest rolloverRequest, ClusterState state, final ActionListener<RolloverResponse> listener) {
        final MetaData metaData = state.metaData();
        TransportRolloverAction.validate(metaData, rolloverRequest);
        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)metaData.getAliasAndIndexLookup().get(rolloverRequest.getAlias());
        IndexMetaData indexMetaData = alias.getWriteIndex();
        final boolean explicitWriteIndex = Boolean.TRUE.equals(indexMetaData.getAliases().get(alias.getAliasName()).writeIndex());
        String sourceProvidedName = indexMetaData.getSettings().get("index.provided_name", indexMetaData.getIndex().getName());
        final String sourceIndexName = indexMetaData.getIndex().getName();
        final String unresolvedName = rolloverRequest.getNewIndexName() != null ? rolloverRequest.getNewIndexName() : TransportRolloverAction.generateRolloverIndexName(sourceProvidedName, this.indexNameExpressionResolver);
        final String rolloverIndexName = this.indexNameExpressionResolver.resolveDateMathExpression(unresolvedName);
        MetaDataCreateIndexService.validateIndexName(rolloverIndexName, state);
        TransportRolloverAction.checkNoDuplicatedAliasInIndexTemplate(metaData, rolloverIndexName, rolloverRequest.getAlias());
        IndicesStatsRequest statsRequest = ((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{rolloverRequest.getAlias()})).clear().indicesOptions(IndicesOptions.fromOptions(true, false, true, true))).docs(true);
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute(IndicesStatsAction.INSTANCE, statsRequest, new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse statsResponse) {
                final Map<String, Boolean> conditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditions().values(), metaData.index(sourceIndexName), statsResponse);
                if (rolloverRequest.isDryRun()) {
                    listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, true, false, false, false));
                    return;
                }
                final List metConditions = rolloverRequest.getConditions().values().stream().filter(condition -> (Boolean)conditionResults.get(condition.toString())).collect(Collectors.toList());
                if (conditionResults.size() == 0 || metConditions.size() > 0) {
                    CreateIndexClusterStateUpdateRequest updateRequest = TransportRolloverAction.prepareCreateIndexRequest(unresolvedName, rolloverIndexName, rolloverRequest);
                    TransportRolloverAction.this.createIndexService.createIndex(updateRequest, ActionListener.wrap(createIndexClusterStateUpdateResponse -> {
                        IndicesAliasesClusterStateUpdateRequest aliasesUpdateRequest = explicitWriteIndex ? TransportRolloverAction.prepareRolloverAliasesWriteIndexUpdateRequest(sourceIndexName, rolloverIndexName, rolloverRequest) : TransportRolloverAction.prepareRolloverAliasesUpdateRequest(sourceIndexName, rolloverIndexName, rolloverRequest);
                        TransportRolloverAction.this.indexAliasesService.indicesAliases(aliasesUpdateRequest, ActionListener.wrap(aliasClusterStateUpdateResponse -> {
                            if (aliasClusterStateUpdateResponse.isAcknowledged()) {
                                TransportRolloverAction.this.clusterService.submitStateUpdateTask("update_rollover_info", new ClusterStateUpdateTask(){

                                    @Override
                                    public ClusterState execute(ClusterState currentState) {
                                        RolloverInfo rolloverInfo = new RolloverInfo(rolloverRequest.getAlias(), metConditions, TransportRolloverAction.this.threadPool.absoluteTimeInMillis());
                                        return ClusterState.builder(currentState).metaData(MetaData.builder(currentState.metaData()).put(IndexMetaData.builder(currentState.metaData().index(sourceIndexName)).putRolloverInfo(rolloverInfo))).build();
                                    }

                                    @Override
                                    public void onFailure(String source, Exception e) {
                                        listener.onFailure(e);
                                    }

                                    @Override
                                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                                        TransportRolloverAction.this.activeShardsObserver.waitForActiveShards(new String[]{rolloverIndexName}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), rolloverRequest.masterNodeTimeout(), isShardsAcknowledged -> listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, true, true, (boolean)isShardsAcknowledged)), listener::onFailure);
                                    }
                                });
                            } else {
                                listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, true, false, false));
                            }
                        }, listener::onFailure));
                    }, listener::onFailure));
                } else {
                    listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, false, false, false));
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static IndicesAliasesClusterStateUpdateRequest prepareRolloverAliasesUpdateRequest(String oldIndex, String newIndex, RolloverRequest request) {
        List<AliasAction> actions = Collections.unmodifiableList(Arrays.asList(new AliasAction.Add(newIndex, request.getAlias(), null, null, null, null), new AliasAction.Remove(oldIndex, request.getAlias())));
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(actions).ackTimeout(request.ackTimeout())).masterNodeTimeout(request.masterNodeTimeout());
        return updateRequest;
    }

    static IndicesAliasesClusterStateUpdateRequest prepareRolloverAliasesWriteIndexUpdateRequest(String oldIndex, String newIndex, RolloverRequest request) {
        List<AliasAction> actions = Collections.unmodifiableList(Arrays.asList(new AliasAction.Add(newIndex, request.getAlias(), null, null, null, true), new AliasAction.Add(oldIndex, request.getAlias(), null, null, null, false)));
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(actions).ackTimeout(request.ackTimeout())).masterNodeTimeout(request.masterNodeTimeout());
        return updateRequest;
    }

    static String generateRolloverIndexName(String sourceIndexName, IndexNameExpressionResolver indexNameExpressionResolver) {
        boolean isDateMath;
        String resolvedName = indexNameExpressionResolver.resolveDateMathExpression(sourceIndexName);
        boolean bl = isDateMath = !sourceIndexName.equals(resolvedName);
        if (INDEX_NAME_PATTERN.matcher(resolvedName).matches()) {
            int numberIndex = sourceIndexName.lastIndexOf("-");
            assert (numberIndex != -1) : "no separator '-' found";
            int counter = Integer.parseInt(sourceIndexName.substring(numberIndex + 1, isDateMath ? sourceIndexName.length() - 1 : sourceIndexName.length()));
            String newName = sourceIndexName.substring(0, numberIndex) + "-" + String.format(Locale.ROOT, "%06d", ++counter) + (isDateMath ? ">" : "");
            return newName;
        }
        throw new IllegalArgumentException("index name [" + sourceIndexName + "] does not match pattern '^.*-\\d+$'");
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable DocsStats docsStats, @Nullable IndexMetaData metaData) {
        if (metaData == null) {
            return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
        }
        long numDocs = docsStats == null ? 0L : docsStats.getCount();
        long indexSize = docsStats == null ? 0L : docsStats.getTotalSizeInBytes();
        Condition.Stats stats = new Condition.Stats(numDocs, metaData.getCreationDate(), new ByteSizeValue(indexSize));
        return conditions.stream().map(condition -> condition.evaluate(stats)).collect(Collectors.toMap(result -> result.condition.toString(), result -> result.matched));
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable IndexMetaData metaData, @Nullable IndicesStatsResponse statsResponse) {
        if (metaData == null) {
            return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
        }
        DocsStats docsStats = Optional.ofNullable(statsResponse).map(stats -> stats.getIndex(metaData.getIndex().getName())).map(indexStats -> indexStats.getPrimaries().getDocs()).orElse(null);
        return TransportRolloverAction.evaluateConditions(conditions, docsStats, metaData);
    }

    static void validate(MetaData metaData, RolloverRequest request) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(request.getAlias());
        if (aliasOrIndex == null) {
            throw new IllegalArgumentException("source alias does not exist");
        }
        if (!aliasOrIndex.isAlias()) {
            throw new IllegalArgumentException("source alias is a concrete index");
        }
        AliasOrIndex.Alias alias = (AliasOrIndex.Alias)aliasOrIndex;
        if (alias.getWriteIndex() == null) {
            throw new IllegalArgumentException("source alias [" + alias.getAliasName() + "] does not point to a write index");
        }
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(String providedIndexName, String targetIndexName, RolloverRequest rolloverRequest) {
        CreateIndexRequest createIndexRequest = rolloverRequest.getCreateIndexRequest();
        createIndexRequest.cause("rollover_index");
        createIndexRequest.index(targetIndexName);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest("rollover_index", targetIndexName, providedIndexName).ackTimeout(createIndexRequest.timeout())).masterNodeTimeout(createIndexRequest.masterNodeTimeout())).settings(createIndexRequest.settings()).aliases(createIndexRequest.aliases()).waitForActiveShards(ActiveShardCount.NONE).mappings(createIndexRequest.mappings());
    }

    static void checkNoDuplicatedAliasInIndexTemplate(MetaData metaData, String rolloverIndexName, String rolloverRequestAlias) {
        List<IndexTemplateMetaData> matchedTemplates = MetaDataIndexTemplateService.findTemplates(metaData, rolloverIndexName);
        for (IndexTemplateMetaData template : matchedTemplates) {
            if (!template.aliases().containsKey(rolloverRequestAlias)) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Rollover alias [%s] can point to multiple indices, found duplicated alias [%s] in index template [%s]", rolloverRequestAlias, template.aliases().keys(), template.name()));
        }
    }
}

