/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Build;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.IngestInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.jvm.JvmInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.os.OsInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.process.ProcessInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPoolInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportInfo;

public class NodeInfo
extends BaseNodeResponse {
    private Version version;
    private Build build;
    @Nullable
    private Settings settings;
    @Nullable
    private OsInfo os;
    @Nullable
    private ProcessInfo process;
    @Nullable
    private JvmInfo jvm;
    @Nullable
    private ThreadPoolInfo threadPool;
    @Nullable
    private TransportInfo transport;
    @Nullable
    private HttpInfo http;
    @Nullable
    private PluginsAndModules plugins;
    @Nullable
    private IngestInfo ingest;
    @Nullable
    private ByteSizeValue totalIndexingBuffer;

    public NodeInfo(StreamInput in) throws IOException {
        super(in);
        this.version = Version.readVersion(in);
        this.build = Build.readBuild(in);
        this.totalIndexingBuffer = in.readBoolean() ? new ByteSizeValue(in.readLong()) : null;
        if (in.readBoolean()) {
            this.settings = Settings.readSettingsFromStream(in);
        }
        this.os = in.readOptionalWriteable(OsInfo::new);
        this.process = in.readOptionalWriteable(ProcessInfo::new);
        this.jvm = in.readOptionalWriteable(JvmInfo::new);
        this.threadPool = in.readOptionalWriteable(ThreadPoolInfo::new);
        this.transport = in.readOptionalWriteable(TransportInfo::new);
        this.http = in.readOptionalWriteable(HttpInfo::new);
        this.plugins = in.readOptionalWriteable(PluginsAndModules::new);
        this.ingest = in.readOptionalWriteable(IngestInfo::new);
    }

    public NodeInfo(Version version, Build build, DiscoveryNode node, @Nullable Settings settings, @Nullable OsInfo os, @Nullable ProcessInfo process, @Nullable JvmInfo jvm, @Nullable ThreadPoolInfo threadPool, @Nullable TransportInfo transport, @Nullable HttpInfo http, @Nullable PluginsAndModules plugins, @Nullable IngestInfo ingest, @Nullable ByteSizeValue totalIndexingBuffer) {
        super(node);
        this.version = version;
        this.build = build;
        this.settings = settings;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.threadPool = threadPool;
        this.transport = transport;
        this.http = http;
        this.plugins = plugins;
        this.ingest = ingest;
        this.totalIndexingBuffer = totalIndexingBuffer;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    public Version getVersion() {
        return this.version;
    }

    public Build getBuild() {
        return this.build;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public OsInfo getOs() {
        return this.os;
    }

    @Nullable
    public ProcessInfo getProcess() {
        return this.process;
    }

    @Nullable
    public JvmInfo getJvm() {
        return this.jvm;
    }

    @Nullable
    public ThreadPoolInfo getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public TransportInfo getTransport() {
        return this.transport;
    }

    @Nullable
    public HttpInfo getHttp() {
        return this.http;
    }

    @Nullable
    public PluginsAndModules getPlugins() {
        return this.plugins;
    }

    @Nullable
    public IngestInfo getIngest() {
        return this.ingest;
    }

    @Nullable
    public ByteSizeValue getTotalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.version.id);
        Build.writeBuild(this.build, out);
        if (this.totalIndexingBuffer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.totalIndexingBuffer.getBytes());
        }
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Settings.writeSettingsToStream(this.settings, out);
        }
        out.writeOptionalWriteable(this.os);
        out.writeOptionalWriteable(this.process);
        out.writeOptionalWriteable(this.jvm);
        out.writeOptionalWriteable(this.threadPool);
        out.writeOptionalWriteable(this.transport);
        out.writeOptionalWriteable(this.http);
        out.writeOptionalWriteable(this.plugins);
        out.writeOptionalWriteable(this.ingest);
    }
}

