/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action;

import java.util.Collection;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;

public class RequestValidators<T extends ActionRequest> {
    private final Collection<RequestValidator<T>> validators;

    public RequestValidators(Collection<RequestValidator<T>> validators) {
        this.validators = validators;
    }

    public Optional<Exception> validateRequest(T request, ClusterState state, Index[] indices) {
        Exception exception = null;
        for (RequestValidator<T> validator : this.validators) {
            Optional<Exception> maybeException = validator.validateRequest(request, state, indices);
            if (!maybeException.isPresent()) continue;
            if (exception == null) {
                exception = maybeException.get();
                continue;
            }
            exception.addSuppressed(maybeException.get());
        }
        return Optional.ofNullable(exception);
    }

    public static interface RequestValidator<T extends ActionRequest> {
        public Optional<Exception> validateRequest(T var1, ClusterState var2, Index[] var3);
    }
}

