/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.mutable;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.mutable.MutableValue;

public class MutableValueDouble
extends MutableValue {
    public double value = 0.0;

    @Override
    public Object toObject() {
        assert (this.exists || 0.0 == this.value);
        return this.exists ? Double.valueOf(this.value) : null;
    }

    @Override
    public void copy(MutableValue source) {
        MutableValueDouble s = (MutableValueDouble)source;
        this.value = s.value;
        this.exists = s.exists;
    }

    @Override
    public MutableValue duplicate() {
        MutableValueDouble v = new MutableValueDouble();
        v.value = this.value;
        v.exists = this.exists;
        return v;
    }

    @Override
    public boolean equalsSameType(Object other) {
        assert (this.exists || 0.0 == this.value);
        MutableValueDouble b = (MutableValueDouble)other;
        return this.value == b.value && this.exists == b.exists;
    }

    @Override
    public int compareSameType(Object other) {
        assert (this.exists || 0.0 == this.value);
        MutableValueDouble b = (MutableValueDouble)other;
        int c = Double.compare(this.value, b.value);
        if (c != 0) {
            return c;
        }
        if (this.exists == b.exists) {
            return 0;
        }
        return this.exists ? 1 : -1;
    }

    @Override
    public int hashCode() {
        assert (this.exists || 0.0 == this.value);
        long x = Double.doubleToLongBits(this.value);
        return (int)x + (int)(x >>> 32);
    }
}

