/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.DataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.UnicodeUtil;

public final class GrowableByteArrayDataOutput
extends DataOutput {
    static final int MIN_UTF8_SIZE_TO_ENABLE_DOUBLE_PASS_ENCODING = 65536;
    private byte[] bytes;
    private int length;
    private byte[] scratchBytes;

    public GrowableByteArrayDataOutput(int cp) {
        this.bytes = new byte[ArrayUtil.oversize(cp, 1)];
        this.length = 0;
    }

    @Override
    public void writeByte(byte b) {
        if (this.length >= this.bytes.length) {
            this.bytes = ArrayUtil.grow(this.bytes);
        }
        this.bytes[this.length++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) {
        int newLength = this.length + len;
        if (newLength > this.bytes.length) {
            this.bytes = ArrayUtil.grow(this.bytes, newLength);
        }
        System.arraycopy(b, off, this.bytes, this.length, len);
        this.length = newLength;
    }

    @Override
    public void writeString(String string) throws IOException {
        int maxLen = UnicodeUtil.maxUTF8Length(string.length());
        if (maxLen <= 65536) {
            this.scratchBytes = this.scratchBytes == null ? new byte[ArrayUtil.oversize(maxLen, 2)] : ArrayUtil.grow(this.scratchBytes, maxLen);
            int len = UnicodeUtil.UTF16toUTF8(string, 0, string.length(), this.scratchBytes);
            this.writeVInt(len);
            this.writeBytes(this.scratchBytes, len);
        } else {
            int numBytes = UnicodeUtil.calcUTF16toUTF8Length(string, 0, string.length());
            this.writeVInt(numBytes);
            this.bytes = ArrayUtil.grow(this.bytes, this.length + numBytes);
            this.length = UnicodeUtil.UTF16toUTF8(string, 0, string.length(), this.bytes, this.length);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getPosition() {
        return this.length;
    }

    public void reset() {
        this.length = 0;
    }
}

