/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.BaseXYZSolid;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;

class dXdYdZSolid
extends BaseXYZSolid {
    protected final double X;
    protected final double Y;
    protected final double Z;
    protected final boolean isOnSurface;
    protected final GeoPoint thePoint;
    protected final GeoPoint[] edgePoints;
    protected static final GeoPoint[] nullPoints = new GeoPoint[0];

    public dXdYdZSolid(PlanetModel planetModel, double X, double Y, double Z) {
        super(planetModel);
        this.X = X;
        this.Y = Y;
        this.Z = Z;
        this.isOnSurface = planetModel.pointOnSurface(X, Y, Z);
        if (this.isOnSurface) {
            this.thePoint = new GeoPoint(X, Y, Z);
            this.edgePoints = new GeoPoint[]{this.thePoint};
        } else {
            this.thePoint = null;
            this.edgePoints = nullPoints;
        }
    }

    public dXdYdZSolid(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.X);
        SerializableObject.writeDouble(outputStream, this.Y);
        SerializableObject.writeDouble(outputStream, this.Z);
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        if (!this.isOnSurface) {
            return false;
        }
        return this.thePoint.isIdentical(x, y, z);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (!this.isOnSurface) {
            return 3;
        }
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof dXdYdZSolid)) {
            return false;
        }
        dXdYdZSolid other = (dXdYdZSolid)o;
        if (!super.equals(other) || other.isOnSurface != this.isOnSurface) {
            return false;
        }
        if (this.isOnSurface) {
            return other.thePoint.equals(this.thePoint);
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isOnSurface ? 1 : 0);
        if (this.isOnSurface) {
            result = 31 * result + this.thePoint.hashCode();
        }
        return result;
    }

    public String toString() {
        return "dXdYdZSolid: {planetmodel=" + this.planetModel + ", isOnSurface=" + this.isOnSurface + ", thePoint=" + this.thePoint + "}";
    }
}

