/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.CollectorManager;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.HitQueue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.HitsThresholdChecker;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocsCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TotalHits;

public abstract class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    ScoreDoc pqTop;
    final HitsThresholdChecker hitsThresholdChecker;

    public static TopScoreDocCollector create(int numHits, int totalHitsThreshold) {
        return TopScoreDocCollector.create(numHits, null, totalHitsThreshold);
    }

    public static TopScoreDocCollector create(int numHits, ScoreDoc after, int totalHitsThreshold) {
        return TopScoreDocCollector.create(numHits, after, HitsThresholdChecker.create(totalHitsThreshold));
    }

    static TopScoreDocCollector create(int numHits, ScoreDoc after, HitsThresholdChecker hitsThresholdChecker) {
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (hitsThresholdChecker == null) {
            throw new IllegalArgumentException("hitsThresholdChecker must be non null");
        }
        if (after == null) {
            return new SimpleTopScoreDocCollector(numHits, hitsThresholdChecker);
        }
        return new PagingTopScoreDocCollector(numHits, after, hitsThresholdChecker);
    }

    public static CollectorManager<TopScoreDocCollector, TopDocs> createSharedManager(final int numHits, final FieldDoc after, final int totalHitsThreshold) {
        return new CollectorManager<TopScoreDocCollector, TopDocs>(){
            private final HitsThresholdChecker hitsThresholdChecker;
            {
                this.hitsThresholdChecker = HitsThresholdChecker.createShared(totalHitsThreshold);
            }

            @Override
            public TopScoreDocCollector newCollector() throws IOException {
                return TopScoreDocCollector.create(numHits, (ScoreDoc)after, this.hitsThresholdChecker);
            }

            @Override
            public TopDocs reduce(Collection<TopScoreDocCollector> collectors) throws IOException {
                TopDocs[] topDocs = new TopDocs[collectors.size()];
                int i = 0;
                for (TopScoreDocCollector collector : collectors) {
                    topDocs[i++] = collector.topDocs();
                }
                return TopDocs.merge(numHits, topDocs);
            }
        };
    }

    TopScoreDocCollector(int numHits, HitsThresholdChecker hitsThresholdChecker) {
        super(new HitQueue(numHits, true));
        assert (hitsThresholdChecker != null);
        this.pqTop = (ScoreDoc)this.pq.top();
        this.hitsThresholdChecker = hitsThresholdChecker;
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        return new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.hitsThresholdChecker.scoreMode();
    }

    protected void updateMinCompetitiveScore(Scorable scorer) throws IOException {
        if (this.hitsThresholdChecker.isThresholdReached() && this.pqTop != null && this.pqTop.score != Float.NEGATIVE_INFINITY) {
            scorer.setMinCompetitiveScore(Math.nextUp(this.pqTop.score));
            this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }
    }

    private static class PagingTopScoreDocCollector
    extends TopScoreDocCollector {
        private final ScoreDoc after;
        private int collectedHits;

        PagingTopScoreDocCollector(int numHits, ScoreDoc after, HitsThresholdChecker hitsThresholdChecker) {
            super(numHits, hitsThresholdChecker);
            this.after = after;
            this.collectedHits = 0;
        }

        @Override
        protected int topDocsSize() {
            return this.collectedHits < this.pq.size() ? this.collectedHits : this.pq.size();
        }

        @Override
        protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
            return results == null ? new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), new ScoreDoc[0]) : new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            final int afterDoc = this.after.doc - context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    assert (score >= 0.0f);
                    ++totalHits;
                    hitsThresholdChecker.incrementHitCount();
                    if (score > ((PagingTopScoreDocCollector)this).after.score || score == ((PagingTopScoreDocCollector)this).after.score && doc <= afterDoc) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO && hitsThresholdChecker.isThresholdReached()) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    if (score <= pqTop.score) {
                        return;
                    }
                    collectedHits++;
                    pqTop.doc = doc + docBase;
                    pqTop.score = score;
                    pqTop = (ScoreDoc)pq.updateTop();
                    this.updateMinCompetitiveScore(this.scorer);
                }
            };
        }
    }

    private static class SimpleTopScoreDocCollector
    extends TopScoreDocCollector {
        SimpleTopScoreDocCollector(int numHits, HitsThresholdChecker hitsThresholdChecker) {
            super(numHits, hitsThresholdChecker);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer(scorer);
                    this.updateMinCompetitiveScore(scorer);
                }

                @Override
                public void collect(int doc) throws IOException {
                    float score = this.scorer.score();
                    assert (score >= 0.0f);
                    ++totalHits;
                    hitsThresholdChecker.incrementHitCount();
                    if (score <= pqTop.score) {
                        if (totalHitsRelation == TotalHits.Relation.EQUAL_TO && hitsThresholdChecker.isThresholdReached()) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    pqTop.doc = doc + docBase;
                    pqTop.score = score;
                    pqTop = (ScoreDoc)pq.updateTop();
                    this.updateMinCompetitiveScore(this.scorer);
                }
            };
        }
    }

    static abstract class ScorerLeafCollector
    implements LeafCollector {
        Scorable scorer;

        ScorerLeafCollector() {
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
        }
    }
}

