/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortedNumericSelector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortedNumericSortField;

public class MultiValuedLongFieldSource
extends LongFieldSource {
    protected final SortedNumericSelector.Type selector;

    public MultiValuedLongFieldSource(String field, SortedNumericSelector.Type selector) {
        super(field);
        this.selector = selector;
        Objects.requireNonNull(field, "Field is required to create a MultiValuedLongFieldSource");
        Objects.requireNonNull(selector, "SortedNumericSelector is required to create a MultiValuedLongFieldSource");
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedNumericSortField(this.field, SortField.Type.LONG, reverse, this.selector);
    }

    @Override
    public String description() {
        return "long(" + this.field + ',' + this.selector.name() + ')';
    }

    @Override
    protected NumericDocValues getNumericDocValues(Map context, LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues sortedDv = DocValues.getSortedNumeric(readerContext.reader(), this.field);
        return SortedNumericSelector.wrap(sortedDv, this.selector, SortField.Type.LONG);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != MultiValuedLongFieldSource.class) {
            return false;
        }
        MultiValuedLongFieldSource other = (MultiValuedLongFieldSource)o;
        if (this.selector != other.selector) {
            return false;
        }
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        return h += this.selector.hashCode();
    }
}

