/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo;

public class XYRectangle {
    public final double minX;
    public final double maxX;
    public final double minY;
    public final double maxY;

    public XYRectangle(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        assert (minX <= maxX);
        assert (minY <= maxY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XYRectangle rectangle = (XYRectangle)o;
        if (Double.compare(rectangle.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxX, this.maxX) != 0) {
            return false;
        }
        return Double.compare(rectangle.maxY, this.maxY) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minX);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("XYRectangle(x=");
        b.append(this.minX);
        b.append(" TO ");
        b.append(this.maxX);
        b.append(" y=");
        b.append(this.minY);
        b.append(" TO ");
        b.append(this.maxY);
        b.append(")");
        return b.toString();
    }
}

