/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.ShapeField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.ShapeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Polygon;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Polygon2D;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.NumericUtils;

final class LatLonShapePolygonQuery
extends ShapeQuery {
    final Polygon[] polygons;
    private final Polygon2D poly2D;

    public LatLonShapePolygonQuery(String field, ShapeField.QueryRelation queryRelation, Polygon ... polygons) {
        super(field, queryRelation);
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] == null) {
                throw new IllegalArgumentException("polygon[" + i + "] must not be null");
            }
            if (!(polygons[i].minLon > polygons[i].maxLon)) continue;
            throw new IllegalArgumentException("LatLonShapePolygonQuery does not currently support querying across dateline.");
        }
        this.polygons = (Polygon[])polygons.clone();
        this.poly2D = Polygon2D.create(polygons);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(minTriangle, minYOffset));
        double minLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(minTriangle, minXOffset));
        double maxLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(maxTriangle, maxYOffset));
        double maxLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(maxTriangle, maxXOffset));
        return this.poly2D.relate(minLat, maxLat, minLon, maxLon);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
        double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
        double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
        double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
        double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
        double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
        switch (queryRelation) {
            case INTERSECTS: {
                return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            case WITHIN: {
                return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            case DISJOINT: {
                return this.poly2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("Polygon(").append(this.polygons[0].toGeoJSON()).append(')');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.polygons, ((LatLonShapePolygonQuery)o).polygons);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.polygons);
        return hash;
    }
}

