/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;

class BinaryRangeDocValues
extends BinaryDocValues {
    private final BinaryDocValues in;
    private byte[] packedValue;
    private final int numDims;
    private final int numBytesPerDimension;
    private int docID = -1;

    BinaryRangeDocValues(BinaryDocValues in, int numDims, int numBytesPerDimension) {
        this.in = in;
        this.numBytesPerDimension = numBytesPerDimension;
        this.numDims = numDims;
        this.packedValue = new byte[2 * numDims * numBytesPerDimension];
    }

    @Override
    public int nextDoc() throws IOException {
        this.docID = this.in.nextDoc();
        if (this.docID != Integer.MAX_VALUE) {
            this.decodeRanges();
        }
        return this.docID;
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    @Override
    public int advance(int target) throws IOException {
        int res = this.in.advance(target);
        if (res != Integer.MAX_VALUE) {
            this.decodeRanges();
        }
        return res;
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        boolean res = this.in.advanceExact(target);
        if (res) {
            this.decodeRanges();
        }
        return res;
    }

    @Override
    public BytesRef binaryValue() throws IOException {
        return this.in.binaryValue();
    }

    public byte[] getPackedValue() {
        return this.packedValue;
    }

    private void decodeRanges() throws IOException {
        BytesRef bytesRef = this.in.binaryValue();
        System.arraycopy(bytesRef.bytes, bytesRef.offset, this.packedValue, 0, 2 * this.numDims * this.numBytesPerDimension);
    }
}

