/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.BlockTermState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.FieldsConsumer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.FieldsProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.PostingsFormat;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene50.Lucene50PostingsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene50.Lucene50PostingsWriter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentReadState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;

public final class Lucene50PostingsFormat
extends PostingsFormat {
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    static final int MAX_SKIP_LEVELS = 10;
    static final String TERMS_CODEC = "Lucene50PostingsWriterTerms";
    static final String DOC_CODEC = "Lucene50PostingsWriterDoc";
    static final String POS_CODEC = "Lucene50PostingsWriterPos";
    static final String PAY_CODEC = "Lucene50PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_IMPACT_SKIP_DATA = 1;
    static final int VERSION_CURRENT = 1;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;
    public static final int BLOCK_SIZE = 128;
    private final BlockTreeTermsReader.FSTLoadMode fstLoadMode;

    public Lucene50PostingsFormat() {
        this(25, 48, BlockTreeTermsReader.FSTLoadMode.AUTO);
    }

    public Lucene50PostingsFormat(int minTermBlockSize, int maxTermBlockSize, BlockTreeTermsReader.FSTLoadMode loadMode) {
        super("Lucene50");
        BlockTreeTermsWriter.validateSettings(minTermBlockSize, maxTermBlockSize);
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
        this.fstLoadMode = loadMode;
    }

    @Override
    public String toString() {
        return this.getName() + "(blocksize=" + 128 + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        BlockTreeTermsWriter blockTreeTermsWriter;
        block3: {
            Lucene50PostingsWriter postingsWriter = new Lucene50PostingsWriter(state);
            boolean success = false;
            try {
                BlockTreeTermsWriter ret = new BlockTreeTermsWriter(state, postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                blockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return blockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        BlockTreeTermsReader blockTreeTermsReader;
        block3: {
            Lucene50PostingsReader postingsReader = new Lucene50PostingsReader(state);
            boolean success = false;
            try {
                BlockTreeTermsReader ret = new BlockTreeTermsReader(postingsReader, state, this.fstLoadMode);
                success = true;
                blockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return blockTreeTermsReader;
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long skipOffset = -1L;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        @Override
        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.skipOffset = other.skipOffset;
            this.singletonDocID = other.singletonDocID;
        }

        @Override
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

