/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc;

import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectLongHashMap;

public class ObjectLongScatterMap<KType>
extends ObjectLongHashMap<KType> {
    public ObjectLongScatterMap() {
        this(4);
    }

    public ObjectLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectLongScatterMap<KType> from(KType[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectLongScatterMap<KType> map = new ObjectLongScatterMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

