/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TotalHits;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchPhaseResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.ProfileShardResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.Suggest;

public final class QuerySearchResult
extends SearchPhaseResult {
    private int from;
    private int size;
    private TopDocsAndMaxScore topDocsAndMaxScore;
    private boolean hasScoreDocs;
    private TotalHits totalHits;
    private float maxScore = Float.NaN;
    private DocValueFormat[] sortValueFormats;
    private InternalAggregations aggregations;
    private boolean hasAggs;
    private Suggest suggest;
    private boolean searchTimedOut;
    private Boolean terminatedEarly = null;
    private ProfileShardResult profileShardResults;
    private boolean hasProfileResults;
    private long serviceTimeEWMA = -1L;
    private int nodeQueueSize = -1;

    public QuerySearchResult() {
    }

    public QuerySearchResult(StreamInput in) throws IOException {
        super(in);
        long id = in.readLong();
        this.readFromWithId(id, in);
    }

    public QuerySearchResult(long id, SearchShardTarget shardTarget) {
        this.requestId = id;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this;
    }

    public void searchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public boolean searchTimedOut() {
        return this.searchTimedOut;
    }

    public void terminatedEarly(boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
    }

    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public TopDocsAndMaxScore topDocs() {
        if (this.topDocsAndMaxScore == null) {
            throw new IllegalStateException("topDocs already consumed");
        }
        return this.topDocsAndMaxScore;
    }

    public boolean hasConsumedTopDocs() {
        return this.topDocsAndMaxScore == null;
    }

    public TopDocsAndMaxScore consumeTopDocs() {
        TopDocsAndMaxScore topDocsAndMaxScore = this.topDocsAndMaxScore;
        if (topDocsAndMaxScore == null) {
            throw new IllegalStateException("topDocs already consumed");
        }
        this.topDocsAndMaxScore = null;
        return topDocsAndMaxScore;
    }

    public void topDocs(TopDocsAndMaxScore topDocs, DocValueFormat[] sortValueFormats) {
        int numFields;
        this.setTopDocs(topDocs);
        if (topDocs.topDocs.scoreDocs.length > 0 && topDocs.topDocs.scoreDocs[0] instanceof FieldDoc && (numFields = ((FieldDoc)topDocs.topDocs.scoreDocs[0]).fields.length) != sortValueFormats.length) {
            throw new IllegalArgumentException("The number of sort fields does not match: " + numFields + " != " + sortValueFormats.length);
        }
        this.sortValueFormats = sortValueFormats;
    }

    private void setTopDocs(TopDocsAndMaxScore topDocsAndMaxScore) {
        this.topDocsAndMaxScore = topDocsAndMaxScore;
        this.totalHits = topDocsAndMaxScore.topDocs.totalHits;
        this.maxScore = topDocsAndMaxScore.maxScore;
        this.hasScoreDocs = topDocsAndMaxScore.topDocs.scoreDocs.length > 0;
    }

    public DocValueFormat[] sortValueFormats() {
        return this.sortValueFormats;
    }

    public boolean hasAggs() {
        return this.hasAggs;
    }

    public Aggregations consumeAggs() {
        if (this.aggregations == null) {
            throw new IllegalStateException("aggs already consumed");
        }
        InternalAggregations aggs = this.aggregations;
        this.aggregations = null;
        return aggs;
    }

    public void aggregations(InternalAggregations aggregations) {
        this.aggregations = aggregations;
        this.hasAggs = aggregations != null;
    }

    public ProfileShardResult consumeProfileResult() {
        if (this.profileShardResults == null) {
            throw new IllegalStateException("profile results already consumed");
        }
        ProfileShardResult result = this.profileShardResults;
        this.profileShardResults = null;
        return result;
    }

    public boolean hasProfileResults() {
        return this.hasProfileResults;
    }

    public void profileResults(ProfileShardResult shardResults) {
        this.profileShardResults = shardResults;
        this.hasProfileResults = shardResults != null;
    }

    public Suggest suggest() {
        return this.suggest;
    }

    public void suggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public int from() {
        return this.from;
    }

    public QuerySearchResult from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public QuerySearchResult size(int size) {
        this.size = size;
        return this;
    }

    public long serviceTimeEWMA() {
        return this.serviceTimeEWMA;
    }

    public QuerySearchResult serviceTimeEWMA(long serviceTimeEWMA) {
        this.serviceTimeEWMA = serviceTimeEWMA;
        return this;
    }

    public int nodeQueueSize() {
        return this.nodeQueueSize;
    }

    public QuerySearchResult nodeQueueSize(int nodeQueueSize) {
        this.nodeQueueSize = nodeQueueSize;
        return this;
    }

    public boolean hasSuggestHits() {
        return this.suggest != null && this.suggest.hasScoreDocs();
    }

    public boolean hasSearchContext() {
        return this.hasScoreDocs || this.hasSuggestHits();
    }

    public void readFromWithId(long id, StreamInput in) throws IOException {
        this.requestId = id;
        this.from = in.readVInt();
        this.size = in.readVInt();
        int numSortFieldsPlus1 = in.readVInt();
        if (numSortFieldsPlus1 == 0) {
            this.sortValueFormats = null;
        } else {
            this.sortValueFormats = new DocValueFormat[numSortFieldsPlus1 - 1];
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                this.sortValueFormats[i] = in.readNamedWriteable(DocValueFormat.class);
            }
        }
        this.setTopDocs(Lucene.readTopDocs(in));
        this.hasAggs = in.readBoolean();
        if (this.hasAggs) {
            this.aggregations = new InternalAggregations(in);
        }
        if (in.getVersion().before(Version.V_7_2_0)) {
            List<SiblingPipelineAggregator> pipelineAggregators = in.readNamedWriteableList(PipelineAggregator.class).stream().map(a -> (SiblingPipelineAggregator)a).collect(Collectors.toList());
            if (this.hasAggs && !pipelineAggregators.isEmpty()) {
                List<InternalAggregation> internalAggs = this.aggregations.asList().stream().map(agg -> (InternalAggregation)agg).collect(Collectors.toList());
                this.aggregations = new InternalAggregations(internalAggs, pipelineAggregators);
            }
        }
        if (in.readBoolean()) {
            this.suggest = new Suggest(in);
        }
        this.searchTimedOut = in.readBoolean();
        this.terminatedEarly = in.readOptionalBoolean();
        this.profileShardResults = in.readOptionalWriteable(ProfileShardResult::new);
        boolean bl = this.hasProfileResults = this.profileShardResults != null;
        if (in.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            this.serviceTimeEWMA = in.readZLong();
            this.nodeQueueSize = in.readInt();
        } else {
            this.serviceTimeEWMA = -1L;
            this.nodeQueueSize = -1;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.requestId);
        this.writeToNoId(out);
    }

    public void writeToNoId(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        if (this.sortValueFormats == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(1 + this.sortValueFormats.length);
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                out.writeNamedWriteable(this.sortValueFormats[i]);
            }
        }
        Lucene.writeTopDocs(out, this.topDocsAndMaxScore);
        if (this.aggregations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.aggregations.writeTo(out);
        }
        if (out.getVersion().before(Version.V_7_2_0)) {
            if (this.aggregations == null) {
                out.writeNamedWriteableList(Collections.emptyList());
            } else {
                out.writeNamedWriteableList(this.aggregations.getTopLevelPipelineAggregators());
            }
        }
        if (this.suggest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.suggest.writeTo(out);
        }
        out.writeBoolean(this.searchTimedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileShardResults);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            out.writeZLong(this.serviceTimeEWMA);
            out.writeInt(this.nodeQueueSize);
        }
    }

    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }
}

